/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing.modifiers;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.mt1006.mocap.api.v1.io.CommandOutput;
import net.mt1006.mocap.api.v1.modifiers.MocapMirror;
import net.mt1006.mocap.api.v1.modifiers.MocapOffset;
import net.mt1006.mocap.api.v1.modifiers.MocapTransformations;
import net.mt1006.mocap.api.v1.modifiers.MocapTransformationsConfig;
import net.mt1006.mocap.command.io.FullCommandInfo;
import net.mt1006.mocap.mocap.files.SceneFiles;
import net.mt1006.mocap.mocap.playing.modifiers.Rotation;
import net.mt1006.mocap.mocap.playing.modifiers.Scale;
import net.mt1006.mocap.mocap.playing.modifiers.TransformationsConfig;
import org.jetbrains.annotations.Nullable;

public class Transformations
implements MocapTransformations {
    public static final Transformations EMPTY = new Transformations(Rotation.ZERO, MocapMirror.NONE, Scale.NORMAL, MocapOffset.ZERO, TransformationsConfig.DEFAULT);
    private final Rotation rotation;
    private final MocapMirror mirror;
    private final Scale scale;
    private final MocapOffset offset;
    private final MocapTransformationsConfig config;
    private final boolean ignorable;

    private Transformations(Rotation rotation, MocapMirror mirror, Scale scale, MocapOffset offset, MocapTransformationsConfig config) {
        this.rotation = rotation;
        this.mirror = mirror;
        this.scale = scale;
        this.offset = offset;
        this.config = config;
        this.ignorable = this.isIgnorable();
    }

    private Transformations(SceneFiles.Reader reader) {
        this.rotation = Rotation.fromDouble(reader.readDouble("rotation", 0.0));
        this.mirror = MocapMirror.fromString(reader.readString("mirror"));
        this.scale = Scale.fromObject(reader.readObject("scale"));
        this.offset = MocapOffset.fromVec3(reader.readVec3("offset"));
        this.config = TransformationsConfig.fromObject(reader.readObject("config"));
        this.ignorable = this.isIgnorable();
    }

    private boolean isIgnorable() {
        return this.rotation.deg == 0.0 && this.mirror == MocapMirror.NONE && this.scale.sceneScale == 1.0 && this.offset.isZero && this.config.isDefault();
    }

    public static Transformations fromObject(@Nullable SceneFiles.Reader reader) {
        return reader != null ? new Transformations(reader) : EMPTY;
    }

    public static MocapTransformations fromLegacyScene(double x, double y, double z) {
        return EMPTY.withOffset(new MocapOffset(x, y, z)).withConfig(TransformationsConfig.LEGACY);
    }

    @Override
    public double getRotation() {
        return this.rotation.deg;
    }

    @Override
    public MocapTransformations withRotation(double rot) {
        return new Transformations(Rotation.fromDouble(rot), this.mirror, this.scale, this.offset, this.config);
    }

    @Override
    public MocapMirror getMirror() {
        return this.mirror;
    }

    @Override
    public MocapTransformations withMirror(MocapMirror mirror) {
        return new Transformations(this.rotation, mirror, this.scale, this.offset, this.config);
    }

    @Override
    public double getScaleOfPlayer() {
        return this.scale.playerScale;
    }

    @Override
    public MocapTransformations withScaleOfPlayer(double scale) {
        return new Transformations(this.rotation, this.mirror, this.scale.ofPlayer(scale), this.offset, this.config);
    }

    @Override
    public double getScaleOfScene() {
        return this.scale.sceneScale;
    }

    @Override
    public MocapTransformations withScaleOfScene(double scale) {
        return new Transformations(this.rotation, this.mirror, this.scale.ofScene(scale), this.offset, this.config);
    }

    @Override
    public MocapOffset getOffset() {
        return this.offset;
    }

    @Override
    public MocapTransformations withOffset(MocapOffset offset) {
        return new Transformations(this.rotation, this.mirror, this.scale, offset, this.config);
    }

    @Override
    public MocapTransformationsConfig getConfig() {
        return this.config;
    }

    @Override
    public MocapTransformations withConfig(MocapTransformationsConfig config) {
        return new Transformations(this.rotation, this.mirror, this.scale, this.offset, config);
    }

    @Override
    public Vec3 calculateCenter(Vec3 startPos) {
        Vec3 center = this.calculateCenterWithoutOffset(startPos);
        return this.config.getCenterOffset().isZero ? center : center.add((Vec3)this.config.getCenterOffset());
    }

    private Vec3 calculateCenterWithoutOffset(Vec3 startPos) {
        if (this.config.getRecordingCenter() != MocapTransformationsConfig.RecordingCenter.AUTO) {
            return switch (this.config.getRecordingCenter()) {
                case MocapTransformationsConfig.RecordingCenter.BLOCK_CENTER -> Transformations.getBlockCenter(startPos);
                case MocapTransformationsConfig.RecordingCenter.BLOCK_CORNER -> Transformations.getBlockCorner(startPos);
                case MocapTransformationsConfig.RecordingCenter.ACTUAL -> startPos;
                default -> throw new IllegalStateException("Unexpected config.centerPoint value");
            };
        }
        if (this.scale.sceneScale == 1.0 || this.scale.sceneScale != (double)((int)this.scale.sceneScale)) {
            Vec3 blockCenter = Transformations.getBlockCenter(startPos);
            Vec3 blockCorner = Transformations.getBlockCorner(startPos);
            return startPos.distanceToSqr(blockCenter) > startPos.distanceToSqr(blockCorner) ? blockCorner : blockCenter;
        }
        return (int)this.scale.sceneScale % 2 == 1 ? Transformations.getBlockCenter(startPos) : Transformations.getBlockCorner(startPos);
    }

    private static Vec3 getBlockCenter(Vec3 vec) {
        return new Vec3((double)Math.round(vec.x - 0.5) + 0.5, Math.floor(vec.y), (double)Math.round(vec.z - 0.5) + 0.5);
    }

    private static Vec3 getBlockCorner(Vec3 vec) {
        return new Vec3((double)Math.round(vec.x), Math.floor(vec.y), (double)Math.round(vec.z));
    }

    @Override
    public Vec3 apply(Vec3 point, Vec3 center) {
        if (this.ignorable) {
            return point;
        }
        point = this.rotation.apply(point, center);
        point = this.mirror.apply(point, center);
        point = this.scale.applyToPoint(point, center);
        point = this.offset.apply(point);
        return point;
    }

    @Override
    public List<? extends BlockPos> applyToBlockPos(List<? extends BlockPos> inputList, Vec3 center) {
        if (this.ignorable) {
            return inputList;
        }
        if (inputList.size() == 1) {
            return this.applyToBlockPos(inputList.get(0), center);
        }
        ArrayList list = new ArrayList(inputList.size());
        inputList.forEach(b -> list.addAll(this.applyToBlockPos((BlockPos)b, center)));
        return list;
    }

    private List<BlockPos> applyToBlockPos(BlockPos blockPos, Vec3 center) {
        if (!(this.config.getRoundBlockPos() || Transformations.isIntVec(center.multiply(2.0, 2.0, 2.0)) && this.rotation.canRotateInt && this.scale.canScaleInt(center) && this.offset.isInt)) {
            return List.of();
        }
        Vec3 point1 = Vec3.atLowerCornerOf((Vec3i)blockPos);
        Vec3 point2 = point1.add(1.0, 1.0, 1.0);
        point1 = this.apply(point1, center);
        point2 = this.apply(point2, center);
        return this.voxelizeCube(point1, point2);
    }

    private List<BlockPos> voxelizeCube(Vec3 pos1, Vec3 pos2) {
        if (Transformations.isIntVec(pos1) && pos1.x + 1.0 == pos2.x && pos1.y + 1.0 == pos2.y && pos1.z + 1.0 == pos2.z) {
            return List.of(new BlockPos((int)pos1.x, (int)pos1.y, (int)pos1.z));
        }
        int startY = (int)Math.round(pos1.y);
        int stopY = (int)Math.round(pos2.y);
        if (Math.abs(pos1.x - pos2.x) == Math.abs(pos1.z - pos2.z)) {
            int startX = (int)Math.round(Math.min(pos1.x, pos2.x));
            int stopX = (int)Math.round(Math.max(pos1.x, pos2.x));
            int startZ = (int)Math.round(Math.min(pos1.z, pos2.z));
            int stopZ = (int)Math.round(Math.max(pos1.z, pos2.z));
            ArrayList<BlockPos> list = new ArrayList<BlockPos>((stopX - startX) * (stopZ - startZ) * (stopY - startY));
            for (int y = startY; y < stopY; ++y) {
                for (int z = startZ; z < stopZ; ++z) {
                    for (int x = startX; x < stopX; ++x) {
                        list.add(new BlockPos(x, y, z));
                    }
                }
            }
            return list;
        }
        double bottomY = pos1.y;
        double sqCenterX = (pos1.x + pos2.x) / 2.0;
        double sqCenterZ = (pos1.z + pos2.z) / 2.0;
        Vec3 pos3 = new Vec3(sqCenterX + (pos1.z - sqCenterZ), bottomY, sqCenterZ - (pos1.x - sqCenterX));
        Vec3 pos4 = new Vec3(sqCenterX + (pos2.z - sqCenterZ), bottomY, sqCenterZ - (pos2.x - sqCenterX));
        int minZ = (int)Math.round(Math.min(Math.min(pos1.z, pos2.z), Math.min(pos3.z, pos4.z)));
        int maxZ = (int)Math.round(Math.max(Math.max(pos1.z, pos2.z), Math.max(pos3.z, pos4.z)));
        Vec3[] vertices = new Vec3[]{pos1, pos3, pos2, pos4};
        ArrayList<Integer> nodesX = new ArrayList<Integer>(4);
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (int z = minZ; z <= maxZ; ++z) {
            nodesX.clear();
            int j = vertices.length - 1;
            int i = 0;
            while (i < vertices.length) {
                Vec3 v1 = vertices[i];
                Vec3 v2 = vertices[j];
                if ((double)z > v1.z && (double)z < v2.z || (double)z > v2.z && (double)z < v1.z) {
                    double x = v1.x + (v2.x - v1.x) * (((double)z - v1.z) / (v2.z - v1.z));
                    nodesX.add((int)Math.round(x));
                }
                j = i++;
            }
            if (nodesX.isEmpty()) continue;
            int startX = (Integer)Collections.min(nodesX);
            int stopX = (Integer)Collections.max(nodesX);
            for (int x = startX; x < stopX; ++x) {
                for (int y = startY; y < stopY; ++y) {
                    list.add(new BlockPos(x, y, z));
                }
            }
        }
        return list;
    }

    private static boolean isIntVec(Vec3 vec) {
        return vec.x == (double)((int)vec.x) && vec.y == (double)((int)vec.y) && vec.z == (double)((int)vec.z);
    }

    @Override
    public BlockState applyToBlockState(BlockState blockState) {
        if (this.ignorable) {
            return blockState;
        }
        if (this.rotation.deg != 0.0) {
            blockState = blockState.rotate(this.rotation.blockRotation);
        }
        if (this.mirror.mirrorX) {
            blockState = blockState.mirror(Mirror.FRONT_BACK);
        }
        if (this.mirror.mirrorZ) {
            blockState = blockState.mirror(Mirror.LEFT_RIGHT);
        }
        return blockState;
    }

    @Override
    public double applyToRotation(double rot) {
        if (this.ignorable) {
            return rot;
        }
        rot += this.rotation.deg;
        if (this.mirror.mirrorX) {
            rot = -rot;
        }
        if (this.mirror.mirrorZ) {
            rot = -(rot + 90.0) - 90.0;
        }
        return Rotation.clampRot(rot);
    }

    @Override
    public void applyScaleToPlayer(Entity entity) {
        this.scale.applyToPlayer(entity);
    }

    @Override
    public void applyScaleToEntity(Entity entity) {
        this.scale.applyToEntity(entity);
    }

    @Override
    public boolean areDefault() {
        return this.rotation.deg == 0.0 && this.mirror == MocapMirror.NONE && this.scale.isNormal() && this.offset.isZero && this.config.isDefault();
    }

    @Override
    public MocapTransformations mergeWithParent(MocapTransformations parent) {
        return this.withScaleOfPlayer(this.scale.playerScale * parent.getScaleOfPlayer());
    }

    @Override
    @Nullable
    public SceneFiles.Writer save() {
        if (this.areDefault()) {
            return null;
        }
        SceneFiles.Writer writer = new SceneFiles.Writer();
        writer.addDouble("rotation", this.rotation.deg, 0.0);
        writer.addString("mirror", this.mirror.save());
        writer.addVec3("offset", this.offset.save());
        writer.addObject("scale", this.scale.save());
        writer.addObject("config", this.config.save());
        return writer;
    }

    @Override
    public void list(CommandOutput out) {
        out.sendSuccess("scenes.element_info.transformations.rotation", this.rotation.deg);
        out.sendSuccess("scenes.element_info.transformations.mirror." + this.mirror.name().toLowerCase(), new Object[0]);
        if (this.scale.playerScale == 1.0) {
            out.sendSuccess("scenes.element_info.transformations.player_scale.normal", new Object[0]);
        } else {
            out.sendSuccess("scenes.element_info.transformations.player_scale.custom", this.scale.playerScale);
        }
        if (this.scale.sceneScale == 1.0) {
            out.sendSuccess("scenes.element_info.transformations.scene_scale.normal", new Object[0]);
        } else {
            out.sendSuccess("scenes.element_info.transformations.scene_scale.custom", this.scale.sceneScale);
        }
        out.sendSuccess("scenes.element_info.transformations.offset", this.offset.x, this.offset.y, this.offset.z);
        this.config.list(out);
    }

    @Override
    @Nullable
    public MocapTransformations modify(FullCommandInfo info, int propertyNodePos) {
        String string = info.getNode(propertyNodePos);
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"rotation", "mirror", "scale", "offset", "config"}, (Object)string, n)) {
            case 0: {
                return this.withRotation(info.getDouble("deg"));
            }
            case 1: {
                MocapMirror newMirror = MocapMirror.fromStringOrNull(info.getNode(propertyNodePos + 1));
                return newMirror != null ? this.withMirror(newMirror) : null;
            }
            case 2: {
                double scaleVal = info.getDouble("scale");
                String string2 = info.getNode(propertyNodePos + 1);
                int n2 = 0;
                return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"of_player", "of_scene"}, (Object)string2, n2)) {
                    case 0 -> this.withScaleOfPlayer(scaleVal);
                    case 1 -> this.withScaleOfScene(scaleVal);
                    default -> null;
                };
            }
            case 3: {
                return this.withOffset(new MocapOffset(info.getDouble("offset_x"), info.getDouble("offset_y"), info.getDouble("offset_z")));
            }
            case 4: {
                MocapTransformationsConfig newConfig = this.config.modify(info, propertyNodePos + 1);
                return newConfig != null ? this.withConfig(newConfig) : null;
            }
        }
        return null;
    }
}

