/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing.playable;

import java.io.File;
import java.io.IOException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.mt1006.mocap.api.v1.controller.MocapPlaybackRoot;
import net.mt1006.mocap.api.v1.controller.config.MocapPlaybackConfig;
import net.mt1006.mocap.api.v1.controller.playable.MocapRecordingFile;
import net.mt1006.mocap.api.v1.io.CommandInfo;
import net.mt1006.mocap.api.v1.io.CommandOutput;
import net.mt1006.mocap.api.v1.modifiers.MocapModifiers;
import net.mt1006.mocap.command.CommandSuggestions;
import net.mt1006.mocap.mocap.files.Files;
import net.mt1006.mocap.mocap.files.RecordingData;
import net.mt1006.mocap.mocap.playing.PlaybackDataManager;
import net.mt1006.mocap.mocap.playing.PlaybackManager;
import net.mt1006.mocap.mocap.playing.playable.Playable;
import net.mt1006.mocap.mocap.playing.playback.Playback;
import net.mt1006.mocap.mocap.playing.playback.PositionTransformer;
import net.mt1006.mocap.mocap.playing.playback.RecordingPlayback;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Nullable;

public class RecordingFile
extends Playable
implements MocapRecordingFile {
    private final String name;
    private final File file;

    private RecordingFile(String name, File file) {
        this.name = name;
        this.file = file;
    }

    @Nullable
    public static RecordingFile get(CommandOutput out, String name) {
        return Files.check(out, name) ? new RecordingFile(name, new File(Files.recordingsDirectory, name + ".mcmocap_rec")) : null;
    }

    @Override
    @Nullable
    public MocapRecordingFile copy(CommandOutput out, MocapRecordingFile destFile) {
        try {
            FileUtils.copyFile((File)this.file, (File)destFile.getFile());
        }
        catch (IOException e) {
            out.sendException(e, "recordings.copy.failed", new Object[0]);
            return null;
        }
        CommandSuggestions.inputSet.add(destFile.getName());
        out.sendSuccess("recordings.copy.success", new Object[0]);
        return destFile;
    }

    @Override
    @Nullable
    public MocapRecordingFile rename(CommandOutput out, MocapRecordingFile destFile) {
        if (!this.file.renameTo(destFile.getFile())) {
            out.sendFailure("recordings.rename.failed", new Object[0]);
            return null;
        }
        CommandSuggestions.inputSet.remove(this.name);
        CommandSuggestions.inputSet.add(destFile.getName());
        out.sendSuccess("recordings.rename.success", new Object[0]);
        return destFile;
    }

    @Override
    public boolean remove(CommandOutput out) {
        if (!this.file.delete()) {
            return out.sendFailure("recordings.remove.failed", new Object[0]);
        }
        CommandSuggestions.inputSet.remove(this.name);
        return out.sendSuccess("recordings.remove.success", new Object[0]);
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    @Nullable
    public MocapPlaybackRoot startPlayback(CommandInfo info, MocapModifiers modifiers, MocapPlaybackConfig config, boolean isHidden) {
        PlaybackDataManager dataManager = new PlaybackDataManager();
        if (!dataManager.loadRecording(info, this)) {
            return null;
        }
        RecordingPlayback playback = RecordingPlayback.start(info, true, dataManager.getRecording(this), config, modifiers, null);
        return playback != null ? PlaybackManager.addPlayback(this, playback, isHidden) : null;
    }

    @Override
    @Nullable
    public Playback startAsSubscene(CommandInfo info, MocapModifiers modifiers, MocapPlaybackConfig config, PlaybackDataManager dataManager, PositionTransformer parentTransformer) {
        return RecordingPlayback.start(info, false, dataManager.getRecording(this), config, modifiers, parentTransformer);
    }

    @Override
    @Nullable
    public Info getInfo(CommandOutput out) {
        return Info.load(out, this);
    }

    public record Info(int version, boolean experimental, int experimentalSubversion, long lengthInTicks, long sizeInBytes, long sizeInOps, Vec3 startPos, @Nullable ResourceLocation assignedDimensionId, @Nullable String assignedPlayerName, boolean legacyEndsWithDeath) implements MocapRecordingFile.Info
    {
        @Nullable
        public static Info load(CommandOutput out, @Nullable RecordingFile file) {
            RecordingData recording = new RecordingData();
            if (!recording.load(out, file, false) && recording.version <= 5) {
                out.sendFailure("recordings.info.failed", new Object[0]);
                return null;
            }
            return new Info(recording.version, recording.experimentalVersion, recording.experimentalSubversion, recording.tickCount, recording.fileSize, recording.actions.size(), recording.startPos, recording.dimensionId, recording.playerName, recording.endsWithDeath);
        }
    }
}

