/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing.playable;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.mt1006.mocap.api.v1.controller.MocapPlaybackRoot;
import net.mt1006.mocap.api.v1.controller.config.MocapPlaybackConfig;
import net.mt1006.mocap.api.v1.controller.playable.MocapSceneElement;
import net.mt1006.mocap.api.v1.controller.playable.MocapSceneFile;
import net.mt1006.mocap.api.v1.io.CommandInfo;
import net.mt1006.mocap.api.v1.io.CommandOutput;
import net.mt1006.mocap.api.v1.modifiers.MocapModifiers;
import net.mt1006.mocap.command.CommandSuggestions;
import net.mt1006.mocap.mocap.files.Files;
import net.mt1006.mocap.mocap.files.SceneData;
import net.mt1006.mocap.mocap.playing.PlaybackDataManager;
import net.mt1006.mocap.mocap.playing.PlaybackManager;
import net.mt1006.mocap.mocap.playing.playable.Playable;
import net.mt1006.mocap.mocap.playing.playback.Playback;
import net.mt1006.mocap.mocap.playing.playback.PositionTransformer;
import net.mt1006.mocap.mocap.playing.playback.ScenePlayback;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Nullable;

public class SceneFile
extends Playable
implements MocapSceneFile {
    private final String name;
    private final File file;

    private SceneFile(String nameWithoutDot, File file) {
        this.name = "." + nameWithoutDot;
        this.file = file;
    }

    @Nullable
    public static SceneFile get(CommandOutput out, String name) {
        if (name.startsWith(".")) {
            name = name.substring(1);
        }
        return Files.check(out, name) ? new SceneFile(name, new File(Files.sceneDirectory, name + ".mcmocap_scene")) : null;
    }

    @Override
    @Nullable
    public MocapSceneFile copy(CommandOutput out, MocapSceneFile destFile) {
        try {
            FileUtils.copyFile((File)this.file, (File)destFile.getFile());
        }
        catch (IOException e) {
            out.sendException(e, "scenes.copy.failed", new Object[0]);
            return null;
        }
        CommandSuggestions.inputSet.add(destFile.getName());
        List<String> elementCache = CommandSuggestions.sceneElementCache.get(destFile.getName());
        if (elementCache != null) {
            CommandSuggestions.sceneElementCache.put(destFile.getName(), new ArrayList<String>(elementCache));
        }
        out.sendSuccess("scenes.copy.success", new Object[0]);
        return destFile;
    }

    @Override
    @Nullable
    public MocapSceneFile rename(CommandOutput out, MocapSceneFile destFile) {
        if (!this.file.renameTo(destFile.getFile())) {
            out.sendFailure("scenes.rename.failed", new Object[0]);
            return null;
        }
        CommandSuggestions.inputSet.remove(this.name);
        CommandSuggestions.inputSet.add(destFile.getName());
        List<String> elementCache = CommandSuggestions.sceneElementCache.get(this.name);
        if (elementCache != null) {
            CommandSuggestions.sceneElementCache.remove(this.name);
            CommandSuggestions.sceneElementCache.put(destFile.getName(), elementCache);
        }
        out.sendSuccess("scenes.rename.success", new Object[0]);
        return destFile;
    }

    @Override
    public boolean remove(CommandOutput out) {
        if (!this.file.delete()) {
            return out.sendFailure("scenes.remove.failed", new Object[0]);
        }
        CommandSuggestions.inputSet.remove(this.name);
        CommandSuggestions.sceneElementCache.remove(this.name);
        return out.sendSuccess("scenes.remove.success", new Object[0]);
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public boolean add(CommandOutput out, MocapSceneElement element) {
        SceneData data = this.loadSceneData(out);
        if (data == null) {
            return false;
        }
        data.elements.add(element);
        return data.save(out, this, this.name, "scenes.add_to.success", "scenes.add_to.error");
    }

    @Override
    @Nullable
    public List<? extends MocapSceneElement> getAll(CommandOutput out) {
        SceneData data = this.loadSceneData(out);
        return data != null ? Collections.unmodifiableList(data.elements) : null;
    }

    @Override
    public boolean replaceAll(CommandOutput out, List<? extends MocapSceneElement> elements) {
        SceneData data = this.loadSceneData(out);
        if (data == null) {
            return false;
        }
        data.elements.clear();
        data.elements.addAll(elements);
        return data.save(out, this, this.name, "scenes.modify.success", "scenes.modify.error");
    }

    @Override
    public boolean clear(CommandOutput out) {
        SceneData data = this.loadSceneData(out);
        if (data == null) {
            return false;
        }
        data.elements.clear();
        return data.save(out, this, this.name, "scenes.modify.success", "scenes.modify.error");
    }

    @Override
    @Nullable
    public MocapPlaybackRoot startPlayback(CommandInfo info, MocapModifiers modifiers, MocapPlaybackConfig config, boolean isHidden) {
        PlaybackDataManager dataManager = new PlaybackDataManager();
        dataManager.loadScene(info, this);
        ScenePlayback playback = ScenePlayback.start(info, true, dataManager, dataManager.getScene(this), config, modifiers, null);
        return playback != null ? PlaybackManager.addPlayback(this, playback, isHidden) : null;
    }

    @Override
    @Nullable
    public Playback startAsSubscene(CommandInfo info, MocapModifiers modifiers, MocapPlaybackConfig config, PlaybackDataManager dataManager, PositionTransformer parentTransformer) {
        return ScenePlayback.start(info, false, dataManager, dataManager.getScene(this), config, modifiers, parentTransformer);
    }

    @Nullable
    public SceneData loadSceneData(CommandOutput out) {
        if (!this.file.exists()) {
            out.sendFailure("scenes.failure.file_not_exists", new Object[0]);
            return null;
        }
        SceneData sceneData = new SceneData();
        return sceneData.load(out, this) ? sceneData : null;
    }
}

