/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing.playback;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.mt1006.mocap.MocapMod;
import net.mt1006.mocap.api.v1.controller.config.MocapPlaybackConfig;
import net.mt1006.mocap.api.v1.extension.MocapPositionTransformer;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapActionContext;
import net.mt1006.mocap.api.v1.modifiers.MocapModifiers;
import net.mt1006.mocap.events.PlayerConnectionEvent;
import net.mt1006.mocap.mocap.playing.playback.PositionTransformer;
import net.mt1006.mocap.mocap.settings.Settings;
import net.mt1006.mocap.network.MocapPacketS2C;
import net.mt1006.mocap.utils.FakePlayer;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

public class ActionContext
implements MocapActionContext {
    private final MocapRecordingData recordingData;
    private final ServerPlayer owner;
    private final PlayerList packetTargets;
    private final MocapActionContext.EntityData mainEntityData;
    private final Map<Integer, MocapActionContext.EntityData> entityDataMap = new HashMap<Integer, MocapActionContext.EntityData>();
    private final ServerLevel level;
    private final MocapPlaybackConfig config;
    private final MocapModifiers modifiers;
    @Nullable
    private final FakePlayer ghostPlayer;
    private final PositionTransformer transformer;
    private boolean mainEntityRemoved = false;
    @Nullable
    private MocapActionContext.EntityData currentEntityData = null;
    private Entity entity;
    private Vec3 position;
    private int repeatCounter = 0;

    public ActionContext(MocapRecordingData recordingData, ServerPlayer owner, PlayerList packetTargets, Entity entity, MocapPlaybackConfig config, MocapModifiers modifiers, @Nullable FakePlayer ghostPlayer, PositionTransformer transformer) {
        if (!(entity.level() instanceof ServerLevel)) {
            throw new RuntimeException("Failed to get ServerLevel for ActionContext!");
        }
        this.recordingData = recordingData;
        this.owner = owner;
        this.packetTargets = packetTargets;
        this.mainEntityData = new MocapActionContext.EntityData(entity, recordingData.getStartPos());
        this.level = (ServerLevel)entity.level();
        this.config = config;
        this.modifiers = modifiers;
        this.ghostPlayer = ghostPlayer;
        this.transformer = transformer;
        this.setMainContextEntity();
    }

    @Override
    public MocapRecordingData getRecordingData() {
        return this.recordingData;
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public ServerLevel getLevel() {
        return this.level;
    }

    @Override
    public MocapPlaybackConfig getConfig() {
        return this.config;
    }

    @Override
    public MocapModifiers getModifiers() {
        return this.modifiers;
    }

    @Override
    public MocapPositionTransformer getTransformer() {
        return this.transformer;
    }

    @Override
    public Entity getMainEntity() {
        return this.mainEntityData.entity;
    }

    @Override
    @Nullable
    public ServerPlayer getDummyPlayer() {
        return this.ghostPlayer;
    }

    @Override
    @Nullable
    public ServerPlayer getRealOrDummyPlayer() {
        return this.entity instanceof ServerPlayer ? (ServerPlayer)this.entity : this.ghostPlayer;
    }

    @Nullable
    public ServerPlayer getLivingEntityOrDummyPlayer() {
        return this.entity instanceof ServerPlayer ? (ServerPlayer)this.entity : this.ghostPlayer;
    }

    @Override
    public void setMainContextEntity() {
        this.setContextEntity(this.mainEntityData);
    }

    @Override
    public boolean setContextEntity(int id) {
        MocapActionContext.EntityData data = this.entityDataMap.get(id);
        if (data == null) {
            return false;
        }
        this.setContextEntity(data);
        return true;
    }

    private void setContextEntity(MocapActionContext.EntityData data) {
        if (this.currentEntityData != null) {
            this.currentEntityData.lastPosition = this.position;
        }
        this.currentEntityData = data;
        this.entity = data.entity;
        this.position = data.lastPosition;
    }

    @Override
    public void broadcast(Packet<?> packet) {
        this.packetTargets.broadcastAll(packet);
    }

    @Override
    public void fluentMovement(Supplier<Packet<?>> packetSupplier) {
        double fluentMovements = (Double)Settings.FLUENT_MOVEMENTS.val;
        if (fluentMovements == 0.0) {
            return;
        }
        Packet<?> packet = packetSupplier.get();
        if (fluentMovements > 0.0) {
            Vec3 pos = this.entity.position();
            double maxDistSqr = fluentMovements * fluentMovements;
            for (ServerPlayer player : this.packetTargets.getPlayers()) {
                if (player.distanceToSqr(pos) > maxDistSqr) continue;
                player.connection.send(packet);
            }
        } else {
            this.packetTargets.broadcastAll(packet);
        }
    }

    public void removeAdditionalEntities() {
        this.entityDataMap.values().forEach(data -> this.removeEntity(data.entity, this.level));
        this.entityDataMap.clear();
    }

    public void removeMainEntity() {
        FakePlayer playerToRemove;
        if (this.mainEntityRemoved) {
            return;
        }
        this.mainEntityRemoved = true;
        if (this.entity instanceof Player) {
            if (!(this.entity instanceof FakePlayer)) {
                Utils.sendMessage((Player)this.owner, "error.failed_to_remove_fake_player", new Object[0]);
                MocapMod.LOGGER.error("Failed to remove fake player!");
                return;
            }
            playerToRemove = (FakePlayer)this.entity;
        } else {
            this.removeEntity(this.entity, this.level);
            if (this.ghostPlayer == null) {
                return;
            }
            playerToRemove = this.ghostPlayer;
        }
        UUID uuid = playerToRemove.getUUID();
        if (PlayerConnectionEvent.nocolPlayers.contains(uuid)) {
            for (ServerPlayer player : PlayerConnectionEvent.players) {
                MocapPacketS2C.sendNocolPlayerRemove(player, uuid);
                PlayerConnectionEvent.removeNocolPlayer(uuid);
            }
        }
        if (playerToRemove != this.ghostPlayer) {
            this.broadcast((Packet<?>)new ClientboundPlayerInfoRemovePacket(List.of(uuid)));
        }
        playerToRemove.remove(Entity.RemovalReason.KILLED);
        playerToRemove.getAdvancements().stopListening();
    }

    @Override
    public Vec3 getPosition() {
        return this.position;
    }

    @Override
    public void changePosition(Vec3 newPos, float rotY, float rotX, boolean transformRot) {
        this.position = newPos;
        Vec3 finPos = this.transformer.transformPos(this.position);
        float finRotY = transformRot ? this.transformer.transformRotation(rotY) : rotY;
        this.entity.snapTo(finPos, finRotY, rotX);
        if (this.ghostPlayer != null && this.entity == this.mainEntityData.entity) {
            this.ghostPlayer.snapTo(finPos, finRotY, rotX);
        }
    }

    @Override
    public void addEntity(int id, Entity entity, Vec3 position) {
        this.entityDataMap.put(id, new MocapActionContext.EntityData(entity, position));
    }

    @Override
    @Nullable
    public MocapActionContext.EntityData getEntityData(int id) {
        return this.entityDataMap.get(id);
    }

    @Override
    public boolean hasEntity(int id) {
        return this.entityDataMap.containsKey(id);
    }

    @Override
    public void incrementRepeatCounter() {
        ++this.repeatCounter;
    }

    @Override
    public boolean shouldStopRepeat(int iter) {
        if (this.repeatCounter == iter) {
            this.repeatCounter = 0;
            return true;
        }
        return false;
    }

    private void removeEntity(Entity entity, ServerLevel level) {
        switch (this.config.getEntitiesAfterPlayback()) {
            case REMOVE: {
                entity.remove(Entity.RemovalReason.KILLED);
            }
            case KILL: {
                entity.invulnerableTime = 0;
                if (entity instanceof FakePlayer) {
                    ((FakePlayer)entity).fakeKill();
                    break;
                }
                entity.kill(level);
                break;
            }
            case LEFT_UNTOUCHED: {
                break;
            }
            case RELEASE_AS_NORMAL: {
                entity.setNoGravity(false);
                entity.setInvulnerable(false);
                entity.removeTag("mocap_entity");
                if (!(entity instanceof Mob)) break;
                ((Mob)entity).setNoAi(false);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.config.getEntitiesAfterPlayback()));
            }
        }
    }
}

