/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing.playback;

import net.minecraft.server.level.ServerPlayer;
import net.mt1006.mocap.api.v1.controller.config.MocapPlaybackConfig;
import net.mt1006.mocap.api.v1.modifiers.MocapModifiers;
import net.mt1006.mocap.api.v1.modifiers.MocapTimeModifiers;
import net.mt1006.mocap.command.CommandsContext;
import net.mt1006.mocap.mocap.recording.RecordingContext;
import net.mt1006.mocap.mocap.recording.RecordingManager;
import org.jetbrains.annotations.Nullable;

public abstract class Playback {
    protected final boolean isRoot;
    @Nullable
    public final ServerPlayer owner;
    public final MocapPlaybackConfig config;
    protected boolean finished = false;
    protected boolean stopped = false;
    protected final MocapModifiers modifiers;
    protected int tickCounter = 0;
    protected int waitOnEnd = 0;

    protected Playback(boolean isRoot, @Nullable ServerPlayer owner, MocapPlaybackConfig config, MocapModifiers modifiers) {
        this.isRoot = isRoot;
        this.owner = owner;
        this.config = config;
        this.modifiers = modifiers;
    }

    public abstract void tick();

    public abstract void stop();

    protected abstract void loop();

    protected boolean isActive() {
        if (this.stopped) {
            return false;
        }
        MocapTimeModifiers timeModifiers = this.modifiers.getTimeModifiers();
        if (timeModifiers.getLoop()) {
            return !timeModifiers.getWaitForParentEnd();
        }
        return !this.finished;
    }

    protected boolean shouldExecuteTick() {
        if (CommandsContext.haveSyncEnabled == 0 || this.owner == null) {
            return true;
        }
        CommandsContext commandsContext = CommandsContext.get(this.owner);
        if (!commandsContext.getSync()) {
            return true;
        }
        for (RecordingContext ctx : RecordingManager.bySourcePlayer(this.owner)) {
            if (ctx.state != RecordingContext.State.RECORDING) continue;
            return true;
        }
        return false;
    }

    protected boolean shouldSelfStop() {
        return (this.isRoot || !this.modifiers.getTimeModifiers().getWaitForParentEnd()) && this.finished;
    }

    protected void finishOrWaitOnEnd() {
        int timeWaitOnEnd = this.modifiers.getTimeModifiers().getWaitOnEnd().ticks;
        if (timeWaitOnEnd == 0) {
            this.finished = true;
        } else {
            this.waitOnEnd = timeWaitOnEnd;
        }
    }
}

