/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing.playback;

import net.minecraft.server.level.ServerPlayer;
import net.mt1006.mocap.api.v1.controller.MocapPlaybackRoot;
import net.mt1006.mocap.api.v1.controller.config.MocapPlaybackConfig;
import net.mt1006.mocap.mocap.playing.playback.Playback;
import org.jetbrains.annotations.Nullable;

public class PlaybackRoot
implements MocapPlaybackRoot {
    private final Playback instance;
    private final String id;
    private final String name;
    private final String suggestedId;
    private final MocapPlaybackConfig config;
    private final boolean isHidden;

    public PlaybackRoot(Playback instance, int id, String name, MocapPlaybackConfig config, boolean isHidden) {
        this.instance = instance;
        this.id = String.valueOf(id);
        this.name = name;
        this.suggestedId = String.format("%03d-%s", id, name);
        this.config = config;
        this.isHidden = isHidden;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getSuggestedId() {
        return this.suggestedId;
    }

    @Override
    public String getRootName() {
        return this.name;
    }

    @Override
    @Nullable
    public ServerPlayer getOwner() {
        return this.instance.owner;
    }

    @Override
    public MocapPlaybackConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean isHidden() {
        return this.isHidden;
    }

    @Override
    public boolean isFinished() {
        return this.instance.finished;
    }

    @Override
    public void stop() {
        if (!this.instance.finished) {
            this.instance.stop();
        }
    }

    public void tick() {
        this.instance.tick();
    }
}

