/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing.playback;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.mt1006.mocap.api.v1.extension.MocapPositionTransformer;
import net.mt1006.mocap.api.v1.modifiers.MocapTransformations;
import org.jetbrains.annotations.Nullable;

public class PositionTransformer
implements MocapPositionTransformer {
    private final MocapTransformations transformations;
    @Nullable
    private final PositionTransformer parent;
    @Nullable
    private final Vec3 center;

    public PositionTransformer(MocapTransformations transformations, @Nullable PositionTransformer parent, @Nullable Vec3 center) {
        this.transformations = transformations;
        this.parent = parent;
        this.center = center;
    }

    @Override
    public Vec3 transformPos(Vec3 point) {
        return this.transformPos(point, null);
    }

    private Vec3 transformPos(Vec3 point, @Nullable Vec3 childCenter) {
        if (childCenter == null && this.center == null) {
            throw new RuntimeException("Both childCenter and center are null!");
        }
        Vec3 centerToUse = this.center != null ? this.center : childCenter;
        point = this.transformations.apply(point, centerToUse);
        return this.parent != null ? this.parent.transformPos(point, centerToUse) : point;
    }

    @Override
    public List<? extends BlockPos> transformBlockPos(BlockPos blockPos, boolean allowScaled) {
        return this.transformBlockPos(List.of(blockPos), null, allowScaled);
    }

    private List<? extends BlockPos> transformBlockPos(List<? extends BlockPos> blockPos, @Nullable Vec3 childCenter, boolean allowScaled) {
        if (childCenter == null && this.center == null) {
            throw new RuntimeException("Both childCenter and center are null!");
        }
        Vec3 centerToUse = this.center != null ? this.center : childCenter;
        List<? extends BlockPos> list = this.transformations.applyToBlockPos(blockPos, centerToUse);
        if (list.size() > 1 && !allowScaled) {
            return List.of();
        }
        return this.parent != null ? this.parent.transformBlockPos(list, centerToUse, allowScaled) : list;
    }

    @Override
    public BlockState transformBlockState(BlockState blockState) {
        blockState = this.transformations.applyToBlockState(blockState);
        return this.parent != null ? this.parent.transformBlockState(blockState) : blockState;
    }

    @Override
    public float transformRotation(float rot) {
        rot = (float)this.transformations.applyToRotation(rot);
        return this.parent != null ? this.parent.transformRotation(rot) : rot;
    }
}

