/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing.playback;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.PropertyMap;
import java.util.UUID;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.mt1006.mocap.MocapMod;
import net.mt1006.mocap.api.v1.controller.config.MocapDimensionSource;
import net.mt1006.mocap.api.v1.controller.config.MocapPlaybackConfig;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.io.CommandInfo;
import net.mt1006.mocap.api.v1.modifiers.MocapModifiers;
import net.mt1006.mocap.api.v1.modifiers.MocapPlayerSkin;
import net.mt1006.mocap.events.PlayerConnectionEvent;
import net.mt1006.mocap.mocap.actions.Die;
import net.mt1006.mocap.mocap.files.RecordingData;
import net.mt1006.mocap.mocap.playing.playback.ActionContext;
import net.mt1006.mocap.mocap.playing.playback.Playback;
import net.mt1006.mocap.mocap.playing.playback.PositionTransformer;
import net.mt1006.mocap.mocap.playing.playback.PreExecuteContext;
import net.mt1006.mocap.mocap.settings.Settings;
import net.mt1006.mocap.network.MocapPacketS2C;
import net.mt1006.mocap.utils.EntityData;
import net.mt1006.mocap.utils.FakePlayer;
import net.mt1006.mocap.utils.ProfileUtils;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

public class RecordingPlayback
extends Playback {
    private final RecordingData recording;
    private final ActionContext ctx;
    private int pos = 0;

    private RecordingPlayback(boolean isRoot, @Nullable ServerPlayer owner, MocapPlaybackConfig config, MocapModifiers modifiers, RecordingData recording, ActionContext ctx) {
        super(isRoot, owner, config, modifiers);
        this.recording = recording;
        this.ctx = ctx;
    }

    @Nullable
    public static RecordingPlayback start(CommandInfo info, boolean isRoot, RecordingData recording, MocapPlaybackConfig config, MocapModifiers modifiers, @Nullable PositionTransformer parentTransformer) {
        Object entity;
        boolean delayedStart;
        if (recording == null) {
            throw new RuntimeException("Provided recording data is null!");
        }
        GameProfile oldProfile = RecordingPlayback.getGameProfile(info, modifiers.getPlayerName(), recording.playerName, config.getStartAsRecorded());
        if (oldProfile == null) {
            info.sendFailure("playback.start.error", new Object[0]);
            info.sendFailure("playback.start.error.profile", new Object[0]);
            return null;
        }
        GameProfile newProfile = RecordingPlayback.createNewProfile(info, oldProfile, modifiers.getPlayerSkin());
        ServerLevel level = RecordingPlayback.getLevel(info, recording, config.getDimensionSource());
        PlayerList packetTargets = info.getServer().getPlayerList();
        FakePlayer ghost = null;
        Vec3 center = modifiers.getTransformations().calculateCenter(recording.startPos);
        PositionTransformer transformer = new PositionTransformer(modifiers.getTransformations(), parentTransformer, center);
        boolean bl = delayedStart = modifiers.getTimeModifiers().getStartDelay().ticks != 0;
        if (!modifiers.getPlayerAsEntity().isEnabled()) {
            FakePlayer fakePlayer = new FakePlayer(level, newProfile, config.getInvulnerablePlayback());
            entity = fakePlayer;
            fakePlayer.gameMode.changeGameModeForPlayer((Boolean)Settings.USE_CREATIVE_GAME_MODE.val != false ? GameType.CREATIVE : GameType.SURVIVAL);
            recording.initEntityPosition((Entity)fakePlayer, transformer, delayedStart);
            modifiers.getTransformations().applyScaleToPlayer((Entity)fakePlayer);
            packetTargets.broadcastAll((Packet)new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.ADD_PLAYER, (ServerPlayer)fakePlayer));
            level.addNewPlayer((ServerPlayer)fakePlayer);
            recording.preExecute(new PreExecuteContext(recording, (Entity)entity, level, config, modifiers, transformer));
            EntityData.PLAYER_SKIN_PARTS.set((Entity)fakePlayer, (byte)127);
            if (!config.getCanPushEntities()) {
                for (ServerPlayer player : PlayerConnectionEvent.players) {
                    MocapPacketS2C.sendNocolPlayerAdd(player, fakePlayer.getUUID());
                    PlayerConnectionEvent.addNocolPlayer(fakePlayer.getUUID());
                }
            }
        } else {
            entity = modifiers.getPlayerAsEntity().createEntity((Level)level);
            if (entity == null) {
                info.sendFailure("playback.start.warning.unknown_entity", modifiers.getPlayerAsEntity().getRawEntityId());
                return null;
            }
            recording.initEntityPosition((Entity)entity, transformer, delayedStart);
            entity.setDeltaMovement(0.0, 0.0, 0.0);
            entity.setInvulnerable(config.getInvulnerablePlayback());
            entity.setNoGravity(true);
            if (entity instanceof Mob) {
                ((Mob)entity).setNoAi(true);
            }
            modifiers.getTransformations().applyScaleToPlayer((Entity)entity);
            level.addFreshEntity(entity);
            recording.preExecute(new PreExecuteContext(recording, (Entity)entity, level, config, modifiers, transformer));
            if (((Boolean)Settings.ALLOW_GHOSTS.val).booleanValue()) {
                ghost = new FakePlayer(level, newProfile, config.getInvulnerablePlayback());
                ghost.gameMode.changeGameModeForPlayer((Boolean)Settings.USE_CREATIVE_GAME_MODE.val != false ? GameType.CREATIVE : GameType.SURVIVAL);
                recording.initEntityPosition((Entity)ghost, transformer, delayedStart);
                level.addNewPlayer((ServerPlayer)ghost);
            }
        }
        ActionContext ctx = new ActionContext(recording, info.getSourcePlayer(), packetTargets, (Entity)entity, config, modifiers, ghost, transformer);
        RecordingPlayback playback = new RecordingPlayback(isRoot, info.getSourcePlayer(), config, modifiers, recording, ctx);
        if (entity instanceof FakePlayer) {
            ((FakePlayer)((Object)entity)).playback = playback;
        } else if (ghost != null) {
            ghost.playback = playback;
        }
        return playback;
    }

    private static ServerLevel getLevel(CommandInfo info, RecordingData recording, MocapDimensionSource dimensionSource) {
        if (recording.dimensionId == null) {
            return switch (dimensionSource) {
                default -> throw new MatchException(null, null);
                case MocapDimensionSource.ASSIGNED_OR_CURRENT, MocapDimensionSource.CURRENT -> info.getLevel();
                case MocapDimensionSource.ASSIGNED_OR_OVERWORLD, MocapDimensionSource.OVERWORLD -> info.getServer().overworld();
            };
        }
        return switch (dimensionSource) {
            default -> throw new MatchException(null, null);
            case MocapDimensionSource.ASSIGNED_OR_CURRENT, MocapDimensionSource.ASSIGNED_OR_OVERWORLD -> info.getServer().getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)recording.dimensionId));
            case MocapDimensionSource.CURRENT -> info.getLevel();
            case MocapDimensionSource.OVERWORLD -> info.getServer().overworld();
        };
    }

    @Nullable
    private static GameProfile getGameProfile(CommandInfo info, @Nullable String profileName, @Nullable String recordedName, boolean startAsRecorded) {
        Entity entity = info.getSourceEntity();
        PlayerList playerList = info.getServer().getPlayerList();
        if (profileName == null) {
            profileName = startAsRecorded && recordedName != null ? recordedName : (entity instanceof ServerPlayer ? ((ServerPlayer)entity).getGameProfile().name() : (!playerList.getPlayers().isEmpty() ? ((ServerPlayer)playerList.getPlayers().get(0)).getGameProfile().name() : "Player"));
        }
        return ProfileUtils.getGameProfile(info.getServer(), profileName);
    }

    private static GameProfile createNewProfile(CommandInfo info, GameProfile oldProfile, MocapPlayerSkin playerSkin) {
        PropertyMap newPropertyMap = playerSkin.addSkinToPropertyMap(info, oldProfile.properties());
        return new GameProfile(UUID.randomUUID(), oldProfile.name(), newPropertyMap);
    }

    @Override
    public void tick() {
        if (this.finished) {
            return;
        }
        if (this.shouldExecuteTick()) {
            if (this.waitOnEnd != 0) {
                if (this.waitOnEnd == 1) {
                    this.finished = true;
                }
                --this.waitOnEnd;
            } else {
                int startDelay = this.modifiers.getTimeModifiers().getStartDelay().ticks;
                int waitOnStart = this.modifiers.getTimeModifiers().getWaitOnStart().ticks;
                if (startDelay == this.tickCounter) {
                    boolean delayedStart;
                    boolean bl = delayedStart = this.modifiers.getTimeModifiers().getStartDelay().ticks != 0;
                    if (delayedStart) {
                        this.recording.initEntityPosition(this.ctx.getEntity(), this.ctx.getTransformer(), false);
                    }
                    this.recording.firstExecute(this.ctx.getEntity());
                    this.tickInitialActions();
                }
                if (startDelay + waitOnStart <= this.tickCounter) {
                    this.tickActions();
                }
            }
            ++this.tickCounter;
        }
        if (this.finished && this.modifiers.getTimeModifiers().getLoop()) {
            this.loop();
        } else if (this.shouldSelfStop()) {
            this.stop();
        }
    }

    private void tickInitialActions() {
        MocapAction.Result result;
        int tempPos = 0;
        block5: while (true) {
            result = this.recording.executeAction(this.ctx, this.config, true, tempPos++);
            switch (result) {
                case OK: 
                case IGNORED: {
                    continue block5;
                }
                case NEXT_TICK: 
                case REPEAT_TICK: 
                case END: {
                    return;
                }
                case ERROR: {
                    Utils.sendMessage((Player)this.owner, "error.playback_error", new Object[0]);
                    MocapMod.LOGGER.error("Something went wrong during initial tick!");
                    this.finished = true;
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)result));
    }

    private void tickActions() {
        MocapAction.Result result;
        block7: while (true) {
            result = this.recording.executeAction(this.ctx, this.config, false, this.pos++);
            switch (result) {
                case OK: 
                case IGNORED: {
                    continue block7;
                }
                case NEXT_TICK: {
                    return;
                }
                case REPEAT_TICK: {
                    --this.pos;
                    return;
                }
                case END: {
                    if (this.recording.endsWithDeath) {
                        Die.INSTANCE.execute(this.ctx);
                    }
                    this.finishOrWaitOnEnd();
                    return;
                }
                case ERROR: {
                    Utils.sendMessage((Player)this.owner, "error.playback_error", new Object[0]);
                    MocapMod.LOGGER.error("Something went wrong during playback!");
                    this.finished = true;
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)result));
    }

    @Override
    public void stop() {
        if (!this.stopped) {
            this.ctx.removeMainEntity();
            this.ctx.removeAdditionalEntities();
            this.finished = true;
            this.stopped = true;
        }
    }

    @Override
    protected void loop() {
        boolean delayedStart = this.modifiers.getTimeModifiers().getStartDelay().ticks != 0;
        this.recording.initEntityPosition(this.ctx.getEntity(), this.ctx.getTransformer(), delayedStart);
        this.ctx.removeAdditionalEntities();
        this.pos = 0;
        this.tickCounter = 0;
        this.finished = false;
    }
}

