/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.recording;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapStateAction;
import net.mt1006.mocap.mocap.actions.ActionType;
import net.mt1006.mocap.mocap.actions.EntityAction;
import org.jetbrains.annotations.Nullable;

public class RecordedEntityState {
    public final List<@Nullable MocapStateAction> actions = new ArrayList<MocapStateAction>(ActionType.Registry.allComparableActions.size());

    public RecordedEntityState(Entity entity) {
        ActionType.Registry.allComparableActions.forEach(supplier -> this.actions.add((MocapStateAction)supplier.apply(entity)));
    }

    public boolean differs(@Nullable RecordedEntityState previousActions) {
        if (previousActions == null) {
            return false;
        }
        for (int i = 0; i < this.actions.size(); ++i) {
            MocapStateAction action = this.actions.get(i);
            MocapStateAction previousAction = previousActions.actions.get(i);
            if (action != null && previousAction == null) {
                throw new RuntimeException("State action isn't null, but previous was!");
            }
            if (action == null || !action.differs(previousAction)) continue;
            return true;
        }
        return false;
    }

    public void saveDifference(List<MocapAction> actionList, @Nullable RecordedEntityState previousActions) {
        if (previousActions == null) {
            for (MocapStateAction action : this.actions) {
                if (action == null || !action.shouldBeInitialized()) continue;
                actionList.add(action);
            }
            return;
        }
        for (int i = 0; i < this.actions.size(); ++i) {
            MocapStateAction action = this.actions.get(i);
            MocapStateAction previousAction = previousActions.actions.get(i);
            if (action != null && previousAction == null) {
                throw new RuntimeException("State action isn't null, but previous was!");
            }
            if (action == null || !action.differs(previousAction)) continue;
            actionList.add(action);
        }
    }

    public void saveTrackedEntityDifference(List<MocapAction> actionList, int id, @Nullable RecordedEntityState previousActions) {
        if (previousActions == null) {
            for (MocapStateAction action : this.actions) {
                if (action == null || !action.shouldBeInitialized()) continue;
                actionList.add(new EntityAction(id, action));
            }
            return;
        }
        for (int i = 0; i < ActionType.Registry.allComparableActions.size(); ++i) {
            MocapStateAction action = this.actions.get(i);
            MocapStateAction previousAction = previousActions.actions.get(i);
            if (action != null && previousAction == null) {
                throw new RuntimeException("State action isn't null, but previous was!");
            }
            if (action == null || !action.differs(previousAction)) continue;
            actionList.add(new EntityAction(id, action));
        }
    }
}

