/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.recording;

import java.io.File;
import java.util.Collection;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.mt1006.mocap.api.v1.controller.config.MocapOnDeath;
import net.mt1006.mocap.api.v1.controller.config.MocapRecordingConfig;
import net.mt1006.mocap.api.v1.extension.MocapActiveRecordingActions;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapBlockAction;
import net.mt1006.mocap.api.v1.io.CommandOutput;
import net.mt1006.mocap.mocap.actions.Die;
import net.mt1006.mocap.mocap.actions.EntityAction;
import net.mt1006.mocap.mocap.actions.NextTick;
import net.mt1006.mocap.mocap.actions.Respawn;
import net.mt1006.mocap.mocap.actions.SkipTicks;
import net.mt1006.mocap.mocap.files.RecordingData;
import net.mt1006.mocap.mocap.files.RecordingFiles;
import net.mt1006.mocap.mocap.playing.modifiers.EntityFilter;
import net.mt1006.mocap.mocap.recording.EntityTracker;
import net.mt1006.mocap.mocap.recording.PositionTracker;
import net.mt1006.mocap.mocap.recording.RecordedEntityState;
import net.mt1006.mocap.mocap.recording.RecordingId;
import net.mt1006.mocap.mocap.recording.RecordingManager;
import net.mt1006.mocap.mocap.recording.RecordingSource;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

public class RecordingContext
implements MocapActiveRecordingActions {
    public final RecordingId id;
    public ServerPlayer recordedPlayer;
    public final RecordingSource source;
    public final MocapRecordingConfig config;
    public final RecordingData data = RecordingData.forWriting();
    public State state = State.WAITING_FOR_ACTION;
    @Nullable
    private RecordedEntityState entityState = null;
    private final PositionTracker positionTracker;
    private final EntityTracker entityTracker = new EntityTracker(this);
    public final EntityFilter entityFilter;
    @Nullable
    public final String instantSave;
    private int tick = 0;
    private int diedOnTick = 0;
    private boolean died = false;
    private ResourceKey<Level> lastDimension;
    public boolean requiresSafeDiscard = false;

    public RecordingContext(RecordingId id, ServerPlayer recordedPlayer, RecordingSource source, MocapRecordingConfig config, @Nullable String instantSave) {
        this.id = id;
        this.recordedPlayer = recordedPlayer;
        this.source = source;
        this.config = config;
        this.positionTracker = new PositionTracker((Entity)recordedPlayer, false, recordedPlayer.position());
        this.entityFilter = EntityFilter.FOR_RECORDING;
        this.instantSave = instantSave;
        this.lastDimension = recordedPlayer.level().dimension();
        this.positionTracker.writeStartPos(this.data);
        if (config.getAssignDimension()) {
            this.data.dimensionId = recordedPlayer.level().dimension().location();
        }
        if (config.getAssignPlayerName()) {
            this.data.playerName = recordedPlayer.getName().getString();
        }
    }

    public void start(boolean sendMessage) {
        this.entityState = null;
        this.state = State.RECORDING;
        if (sendMessage) {
            Utils.sendMessage((Player)this.source.player, "recording.start.recording_started", new Object[0]);
        }
    }

    public void stop(CommandOutput out) {
        switch (this.state.ordinal()) {
            case 0: {
                State state = State.CANCELED;
                break;
            }
            case 1: 
            case 2: {
                State state = State.WAITING_FOR_DECISION;
                break;
            }
            default: {
                State state = this.state = State.UNDEFINED;
            }
        }
        if (this.state == State.WAITING_FOR_DECISION && this.instantSave != null) {
            RecordingManager.saveSingle(out, this, this.instantSave, false);
        }
        if (this.state.removed) {
            RecordingManager.removeContext(this);
        }
    }

    public void discard() {
        switch (this.state.ordinal()) {
            case 0: {
                State state = State.CANCELED;
                break;
            }
            case 2: {
                State state = State.DISCARDED;
                break;
            }
            default: {
                State state = this.state = State.UNDEFINED;
            }
        }
        if (this.state.removed) {
            RecordingManager.removeContext(this);
        }
    }

    public void save(File recordingFile, String name) {
        if (this.state == State.WAITING_FOR_DECISION) {
            if (!RecordingFiles.save(CommandOutput.LOGS, recordingFile, name, this.data)) {
                return;
            }
            this.state = State.SAVED;
        } else {
            this.state = State.UNDEFINED;
        }
        if (this.state.removed) {
            RecordingManager.removeContext(this);
        }
    }

    public void onTick() {
        switch (this.state.ordinal()) {
            case 0: {
                this.onTickWaiting();
                break;
            }
            case 1: {
                this.onTickRecording();
            }
        }
    }

    private void onTickWaiting() {
        RecordedEntityState newEntityState = new RecordedEntityState((Entity)this.recordedPlayer);
        if (newEntityState.differs(this.entityState) || this.positionTracker.getDelta() != null) {
            this.start(true);
        } else {
            this.entityState = newEntityState;
        }
    }

    private void onTickRecording() {
        ++this.tick;
        if (this.died) {
            int tickDiff = this.tick - this.diedOnTick;
            if (this.config.getOnDeath() == MocapOnDeath.CONTINUE_SYNCED || tickDiff < 20) {
                this.entityTracker.onTick();
                this.addTickAction();
            }
            if (tickDiff == 20) {
                if (this.config.getOnDeath() == MocapOnDeath.END_RECORDING) {
                    this.selfStop(true);
                } else if (this.config.getOnDeath() != MocapOnDeath.SPLIT_RECORDING) {
                    this.positionTracker.teleportFarAway(this.data.actions);
                }
            }
            return;
        }
        RecordedEntityState newEntityState = new RecordedEntityState((Entity)this.recordedPlayer);
        newEntityState.saveDifference(this.data.actions, this.entityState);
        this.entityState = newEntityState;
        this.positionTracker.onTick(this.data.actions, null);
        this.entityTracker.onTick();
        if (this.recordedPlayer.isDeadOrDying()) {
            this.addAction(Die.INSTANCE);
            this.died = true;
            this.diedOnTick = this.tick;
            if (this.config.getOnDeath() != MocapOnDeath.END_RECORDING) {
                RecordingManager.waitingForRespawn.put(this.recordedPlayer, this);
            }
        } else if (this.recordedPlayer.level().dimension() != this.lastDimension) {
            this.onDimensionChange();
            this.lastDimension = this.recordedPlayer.level().dimension();
        } else if (this.recordedPlayer.isRemoved()) {
            this.selfStop(false);
        }
        this.addTickAction();
    }

    private void onDimensionChange() {
        switch (this.config.getOnChangeDimension()) {
            case NOTHING: {
                break;
            }
            case END_RECORDING: {
                this.selfStop(true);
                break;
            }
            case SPLIT_RECORDING: {
                this.splitRecording(this.recordedPlayer);
                break;
            }
            default: {
                throw new RuntimeException("Unknown state: " + String.valueOf((Object)this.config.getOnChangeDimension()));
            }
        }
    }

    public void onRespawn(ServerPlayer newPlayer) {
        if (this.config.getOnDeath() == MocapOnDeath.SPLIT_RECORDING) {
            this.splitRecording(newPlayer);
            return;
        }
        this.died = false;
        this.recordedPlayer = newPlayer;
        this.positionTracker.setEntity((Entity)newPlayer);
        this.addAction(Respawn.INSTANCE);
    }

    private void selfStop(boolean requiresSafeDiscard) {
        this.requiresSafeDiscard = requiresSafeDiscard;
        this.state = State.WAITING_FOR_DECISION;
        RecordingManager.sendStopMessage(msg -> Utils.sendMessage((Player)this.source.player, msg, new Object[0]), this, this.source.player);
    }

    public void splitRecording(ServerPlayer newPlayer) {
        boolean success;
        this.state = State.WAITING_FOR_DECISION;
        Utils.sendMessage((Player)this.source.player, "recording.stop.split", new Object[0]);
        boolean bl = success = RecordingManager.start(newPlayer, this.source, this.config, null, true, false) != null;
        if (!success) {
            Utils.sendMessage((Player)this.source.player, "recording.stop.split.error", new Object[0]);
        }
    }

    @Override
    public void addAction(MocapAction action) {
        if (this.state != State.RECORDING) {
            if (this.state == State.WAITING_FOR_ACTION) {
                this.start(true);
            } else {
                return;
            }
        }
        this.data.actions.add(action);
        if (action instanceof MocapBlockAction) {
            this.data.blockActions.add((MocapBlockAction)action);
        }
    }

    @Override
    public void addEntityAction(MocapAction action, int entityId) {
        this.addAction(new EntityAction(entityId, action));
    }

    @Override
    public Collection<? extends MocapActiveRecordingActions.TrackedEntity> getTrackedEntities() {
        return this.entityTracker.getAll();
    }

    public void addTickAction() {
        SkipTicks skipTicks;
        int lastElementPos = this.data.actions.size() - 1;
        if (lastElementPos < 0) {
            this.addAction(NextTick.INSTANCE);
            return;
        }
        MocapAction lastElement = this.data.actions.get(lastElementPos);
        if (lastElement instanceof NextTick) {
            this.data.actions.set(lastElementPos, new SkipTicks(2));
        } else if (lastElement instanceof SkipTicks && (skipTicks = (SkipTicks)lastElement).canBeModified()) {
            this.data.actions.set(lastElementPos, skipTicks.increment());
        } else {
            this.addAction(NextTick.INSTANCE);
        }
    }

    @Nullable
    public EntityTracker.TrackedEntity getTrackedEntity(Entity entity) {
        return this.entityTracker.get(entity);
    }

    public int getTick() {
        return this.tick;
    }

    public boolean isRemoved() {
        return this.state.removed;
    }

    public static enum State {
        WAITING_FOR_ACTION(false),
        RECORDING(false),
        WAITING_FOR_DECISION(false),
        CANCELED(true),
        DISCARDED(true),
        SAVED(true),
        UNDEFINED(true);

        public final boolean removed;

        private State(boolean removed) {
            this.removed = removed;
        }
    }
}

