/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.recording;

import java.util.Collection;
import net.minecraft.server.level.ServerPlayer;
import net.mt1006.mocap.MocapMod;
import net.mt1006.mocap.mocap.recording.RecordingContext;
import org.jetbrains.annotations.Nullable;

public class RecordingId {
    public static final RecordingId ALL = new RecordingId("_._._", null);
    @Nullable
    public final String str;
    @Nullable
    private final String source;
    @Nullable
    private final String recorded;
    @Nullable
    private final String name;

    public RecordingId(String id, @Nullable String sourceName) {
        String[] parts;
        if (id.startsWith("-")) {
            id = id.substring(1);
        }
        if (!RecordingId.verifyParts(parts = id.split("\\."))) {
            this.str = null;
            this.source = null;
            this.recorded = null;
            this.name = null;
            return;
        }
        switch (parts.length) {
            case 1: {
                this.source = sourceName;
                this.recorded = RecordingId.getNullablePart(parts[0]);
                this.name = parts[0].equals("_") ? null : "1";
                break;
            }
            case 2: {
                this.source = sourceName;
                this.recorded = RecordingId.getNullablePart(parts[0]);
                this.name = RecordingId.getNullablePart(parts[1]);
                break;
            }
            case 3: {
                this.source = RecordingId.getNullablePart(parts[0]);
                this.recorded = RecordingId.getNullablePart(parts[1]);
                this.name = RecordingId.getNullablePart(parts[2]);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        this.str = String.format("-%s.%s.%s", RecordingId.getNotNullPart(this.source), RecordingId.getNotNullPart(this.recorded), RecordingId.getNotNullPart(this.name));
    }

    public RecordingId(Collection<RecordingContext> contexts, ServerPlayer recordedPlayer, @Nullable String source) {
        if (source == null) {
            source = "+mc";
        }
        String recorded = recordedPlayer.getName().getString();
        long maxId = 0L;
        for (RecordingContext ctx : contexts) {
            if (ctx.id.source == null || ctx.id.recorded == null) {
                MocapMod.LOGGER.warn("Found context with non-single id");
                continue;
            }
            if (!ctx.id.source.equals(source) || !ctx.id.recorded.equals(recorded)) continue;
            long num = -1L;
            if (ctx.id.name != null) {
                try {
                    num = Long.parseLong(ctx.id.name);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (num <= maxId) continue;
            maxId = num;
        }
        String name = Long.toString(maxId + 1L);
        String finalId = String.format("-%s.%s.%s", source, recorded, name);
        for (RecordingContext ctx : contexts) {
            if (ctx.id.str == null) {
                MocapMod.LOGGER.warn("Found context with improper id");
                continue;
            }
            if (!ctx.id.str.equals(finalId)) continue;
            MocapMod.LOGGER.error("Tried to create context with already existing id!");
            this.str = null;
            this.source = null;
            this.recorded = null;
            this.name = null;
            return;
        }
        this.str = finalId;
        this.source = source;
        this.recorded = recorded;
        this.name = name;
    }

    public boolean isSingle() {
        return this.source != null && this.recorded != null && this.name != null;
    }

    public boolean isProper() {
        return this.str != null;
    }

    public boolean matches(RecordingId id) {
        return !(id.source != null && !id.source.equals(this.source) || id.recorded != null && !id.recorded.equals(this.recorded) || id.name != null && !id.name.equals(this.name));
    }

    private static String getNotNullPart(@Nullable String part) {
        return part != null ? part : "_";
    }

    @Nullable
    private static String getNullablePart(String part) {
        return part.equals("_") ? null : part;
    }

    private static boolean verifyParts(String[] parts) {
        if (parts.length > 3 || parts.length == 0) {
            return false;
        }
        for (String part : parts) {
            if (RecordingId.isProperPartName(part)) continue;
            return false;
        }
        boolean shouldBeGroup = parts[parts.length - 1].equals("_");
        if (!shouldBeGroup) {
            for (String part : parts) {
                if (!part.equals("_")) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isProperPartName(String part) {
        if (part.isEmpty()) {
            return false;
        }
        if (part.equals("_")) {
            return true;
        }
        for (char c : part.toCharArray()) {
            if (RecordingId.isAllowedPartChar(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAllowedPartChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '+';
    }
}

