/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.utils;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.UUIDUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.CachedUserNameToIdResolver;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.UserNameToIdResolver;
import net.mt1006.mocap.MocapMod;

public class ProfileUtils {
    public static final String USERID_CACHE_FILE = "usercache.json";
    public static final Map<String, GameProfile> gameProfileCache = Collections.synchronizedMap(new HashMap());
    public static UserNameToIdResolver profileCache = null;
    public static MinecraftSessionService sessionService = null;

    public static GameProfile getGameProfile(MinecraftServer server, String playerName) {
        ProfileResult profileResult;
        UUID offlineUUID;
        Optional playerInfoOpt;
        NameAndId playerInfo;
        GameProfile gameProfile;
        Property property;
        if (gameProfileCache.containsKey(playerName)) {
            return gameProfileCache.get(playerName);
        }
        if (profileCache == null || sessionService == null) {
            if (MocapMod.isDedicatedServer) {
                sessionService = server.services().sessionService();
                profileCache = server.services().nameToIdCache();
            } else {
                ProfileUtils.setClientProfileLookupObjects();
            }
        }
        if ((property = (Property)Iterables.getFirst((Iterable)(gameProfile = new GameProfile((playerInfo = (playerInfoOpt = profileCache != null ? profileCache.get(playerName) : Optional.empty()).orElse(new NameAndId(offlineUUID = UUIDUtil.createOfflinePlayerUUID((String)playerName), playerName))).id(), playerInfo.name())).properties().get((Object)"textures"), null)) == null && !playerInfo.id().equals(offlineUUID) && (profileResult = sessionService.fetchProfile(gameProfile.id(), true)) != null) {
            gameProfile = profileResult.profile();
        }
        gameProfileCache.put(gameProfile.name(), gameProfile);
        return gameProfile;
    }

    private static void setClientProfileLookupObjects() {
        YggdrasilAuthenticationService yggdrasilauthenticationservice = new YggdrasilAuthenticationService(Minecraft.getInstance().getProxy());
        sessionService = yggdrasilauthenticationservice.createMinecraftSessionService();
        GameProfileRepository gameprofilerepository = yggdrasilauthenticationservice.createProfileRepository();
        profileCache = new CachedUserNameToIdResolver(gameprofilerepository, new File(Minecraft.getInstance().gameDirectory, USERID_CACHE_FILE));
    }
}

