package net.mt1006.mocap.api.v1.controller;

import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.mt1006.mocap.api.v1.controller.config.MocapRecordingConfig;
import net.mt1006.mocap.api.v1.controller.playable.MocapActiveRecording;
import net.mt1006.mocap.api.v1.io.CommandInfo;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public interface MocapController
{
	CommandInfo getCommandInfo();

	CommandInfo getCommandInfoForLevel(class_3218 level);

	@Nullable MocapPlaybackRoot findPlayback(String id);

	List<? extends MocapPlaybackRoot> getActivePlaybacks();

	@Nullable MocapActiveRecording startRecording(class_3222 player);

	@Nullable MocapActiveRecording startRecording(class_3222 player, MocapRecordingConfig config, boolean startInstantly);

	@Nullable String getSetting(String name);

	boolean setSetting(String name, String val);

	boolean resetSetting(String name);
}
