package net.mt1006.mocap.api.v1.extension.actions;

import org.jetbrains.annotations.Nullable;

import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_3222;

public interface MocapActionContext extends MocapBasicActionContext
{
	class_1297 getMainEntity();

	@Nullable class_3222 getDummyPlayer();

	@Nullable class_3222 getRealOrDummyPlayer();

	@Nullable class_1309 getLivingEntityOrDummyPlayer();

	void setMainContextEntity();

	boolean setContextEntity(int id);

	void broadcast(class_2596<?> packet);

	void fluentMovement(Supplier<class_2596<?>> packetSupplier);

	class_243 getPosition();

	void changePosition(class_243 newPos, float rotY, float rotX, boolean transformRot);

	void addEntity(int id, class_1297 entity, class_243 position);

	@Nullable EntityData getEntityData(int id);

	boolean hasEntity(int id);

	void incrementRepeatCounter();

	boolean shouldStopRepeat(int iter);

	class EntityData
	{
		public final class_1297 entity;
		public class_243 lastPosition;

		public EntityData(class_1297 entity, class_243 startPos)
		{
			this.entity = entity;
			this.lastPosition = startPos;
		}
	}
}
