package net.mt1006.mocap.api.v1.modifiers;

import net.minecraft.class_1299;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.mt1006.mocap.mocap.playing.modifiers.EntityFilter;

public class MocapEntityFilterBuilder
{
	private final StringBuilder builder = new StringBuilder();

	public MocapEntityFilterBuilder includeEntity(class_2960 id)
	{
		builder.append(id.toString());
		return this;
	}

	public MocapEntityFilterBuilder excludeEntity(class_2960 id)
	{
		builder.append("-");
		return includeEntity(id);
	}

	public MocapEntityFilterBuilder includeEntity(class_1299<?> entityType)
	{
		return includeEntity(class_7923.field_41177.method_10221(entityType));
	}

	public MocapEntityFilterBuilder excludeEntity(class_1299<?> entityType)
	{
		return excludeEntity(class_7923.field_41177.method_10221(entityType));
	}

	public MocapEntityFilterBuilder includeAll()
	{
		builder.append("*");
		return this;
	}

	public MocapEntityFilterBuilder excludeAll()
	{
		builder.append("-*");
		return this;
	}

	public MocapEntityFilterBuilder includeNamespace(String namespace)
	{
		if (!class_2960.method_20209(namespace)) { throw new class_151("Invalid namespace!"); }
		builder.append(namespace);
		builder.append(":*");
		return this;
	}

	public MocapEntityFilterBuilder excludeNamespace(String namespace)
	{
		builder.append("-");
		return includeNamespace(namespace);
	}

	public MocapEntityFilterBuilder includeTag(String tag)
	{
		//TODO: check for semicolons
		builder.append("$");
		builder.append(tag);
		return this;
	}

	public MocapEntityFilterBuilder excludeTag(String tag)
	{
		builder.append("-");
		return includeTag(tag);
	}

	public MocapEntityFilterBuilder includeGroup(Group group)
	{
		builder.append("@");
		builder.append(group.name());
		builder.append(";");
		return this;
	}

	public MocapEntityFilterBuilder excludeGroup(Group group)
	{
		builder.append("-");
		return includeGroup(group);
	}

	public MocapEntityFilterBuilder appendFilter(String filter)
	{
		builder.append(filter);
		return this;
	}

	public MocapEntityFilter build()
	{
		if (builder.isEmpty()) { includeGroup(Group.NONE); }
		return EntityFilter.fromString(builder.toString());
	}

	public enum Group
	{
		NONE,
		VEHICLES,
		PROJECTILES,
		ITEMS,
		MOBS,
		MINECARTS
	}
}
