package net.mt1006.mocap.api.v1.modifiers;

import net.minecraft.class_243;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class MocapOffset extends class_243
{
	public static final MocapOffset ZERO = new MocapOffset(0.0, 0.0, 0.0);

	@ApiStatus.Internal
	public final boolean isZero, isInt;

	public MocapOffset(double x, double y, double z)
	{
		super(x, y, z);
		isZero = (x == 0.0 && y == 0.0 && z == 0.0);
		isInt = (isZero || (x == (int)x && y == (int)y && z == (int)z));
	}

	public static MocapOffset fromVec3(@Nullable class_243 vec)
	{
		return vec != null ? new MocapOffset(vec.field_1352, vec.field_1351, vec.field_1350) : ZERO;
	}

	@ApiStatus.Internal
	public @Nullable class_243 save()
	{
		return isZero ? null : this;
	}

	@ApiStatus.Internal
	public class_243 apply(class_243 point)
	{
		return new class_243(field_1352 + point.field_1352, field_1351 + point.field_1351, field_1350 + point.field_1350);
	}
}
