package net.mt1006.mocap.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.datafixers.util.Pair;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2212;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import net.minecraft.class_7924;
import net.mt1006.mocap.command.io.FullCommandInfo;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;

public class CommandUtils
{
	public static ArgumentBuilder<class_2168, ?> playerNameArgument(Command<class_2168> command)
	{
		return class_2170.method_9244("player_name", StringArgumentType.string()).executes(command);
	}

	public static ArgumentBuilder<class_2168, ?> playerArguments(class_7157 buildContext, Command<class_2168> command)
	{
		return withModelArguments(buildContext, playerNameArgument(command), command, true);
	}

	public static ArgumentBuilder<class_2168, ?> withModelArguments(class_7157 buildContext, ArgumentBuilder<class_2168, ?> builder,
																			Command<class_2168> command, boolean addPlayerAsEntity)
	{
		builder.then(class_2170.method_9247("skin_from_player").then(class_2170.method_9244("skin_player_name", StringArgumentType.greedyString()).executes(command)));
		builder.then(class_2170.method_9247("skin_from_file").then(class_2170.method_9244("skin_filename",
				StringArgumentType.greedyString()).suggests(CommandSuggestions::skinFile).executes(command)));
		builder.then(class_2170.method_9247("skin_from_mineskin").then(class_2170.method_9244("mineskin_url", StringArgumentType.greedyString()).executes(command)));
		if (addPlayerAsEntity)
		{
			builder.then(class_2170.method_9247("player_as_entity").
				then(class_2170.method_9244("entity", class_7733.method_45603(buildContext, class_7924.field_41266)).executes(command).
				then(class_2170.method_9244("nbt", class_2212.method_9389()).executes(command))));
		}
		return builder;
	}

	public static ArgumentBuilder<class_2168, ?> withModifiers(class_7157 buildContext,
																	   ArgumentBuilder<class_2168, ?> builder,
																	   Command<class_2168> command, boolean isScene)
	{
		builder.then(class_2170.method_9247("time").
			then(class_2170.method_9247("start_delay").then(class_2170.method_9244("seconds", DoubleArgumentType.doubleArg(0.0)).executes(command))).
			then(class_2170.method_9247("wait_on_start").then(class_2170.method_9244("seconds", DoubleArgumentType.doubleArg(0.0)).executes(command))).
			then(class_2170.method_9247("wait_on_end").then(class_2170.method_9244("seconds", DoubleArgumentType.doubleArg(0.0)).executes(command))).
			then(class_2170.method_9247("wait_for_parent_end").
				then(class_2170.method_9244("wait_for_parent_end", BoolArgumentType.bool()).executes(command))).
			then(class_2170.method_9247("loop").
				then(class_2170.method_9244("loop", BoolArgumentType.bool()).executes(command))));
		builder.then(class_2170.method_9247("transformations").
			then(class_2170.method_9247("rotation").
				then(class_2170.method_9244("deg", DoubleArgumentType.doubleArg()).executes(command))).
			then(class_2170.method_9247("mirror").
				then(class_2170.method_9247("none").executes(command)).
				then(class_2170.method_9247("x").executes(command)).
				then(class_2170.method_9247("z").executes(command)).
				then(class_2170.method_9247("xz").executes(command))).
			then(class_2170.method_9247("scale").
				then(class_2170.method_9247("of_player").
					then(class_2170.method_9244("scale", DoubleArgumentType.doubleArg(0.0)).executes(command))).
				then(class_2170.method_9247("of_scene").
					then(class_2170.method_9244("scale", DoubleArgumentType.doubleArg(0.0)).executes(command)))).
			then(class_2170.method_9247("offset").
				then(class_2170.method_9244("offset_x", DoubleArgumentType.doubleArg()).
				then(class_2170.method_9244("offset_y", DoubleArgumentType.doubleArg()).
				then(class_2170.method_9244("offset_z", DoubleArgumentType.doubleArg()).executes(command))))).
			then(class_2170.method_9247("config").
				then(class_2170.method_9247("round_block_pos").
					then(class_2170.method_9244("round", BoolArgumentType.bool()).executes(command))).
				then(class_2170.method_9247("recording_center").
					then(class_2170.method_9247("auto").executes(command)).
					then(class_2170.method_9247("block_center").executes(command)).
					then(class_2170.method_9247("block_corner").executes(command)).
					then(class_2170.method_9247("actual").executes(command))).
				then(class_2170.method_9247("scene_center").
					then(class_2170.method_9247("common_first").executes(command)).
					then(class_2170.method_9247("common_last").executes(command)).
					then(class_2170.method_9247("common_specific").
						then(class_2170.method_9244("specific_scene_element", StringArgumentType.string()).executes(command))). //TODO: add suggestions
					then(class_2170.method_9247("individual").executes(command))).
				then(class_2170.method_9247("center_offset").
					then(class_2170.method_9244("offset_x", DoubleArgumentType.doubleArg()).
					then(class_2170.method_9244("offset_y", DoubleArgumentType.doubleArg()).
					then(class_2170.method_9244("offset_z", DoubleArgumentType.doubleArg()).executes(command)))))));
		builder.then(class_2170.method_9247("player_name").
			then(class_2170.method_9247("inherited").executes(command)).
			then(class_2170.method_9247("blank").executes(command)).
			then(class_2170.method_9247("set").then(playerNameArgument(command))));
		builder.then(withModelArguments(buildContext, class_2170.method_9247("player_skin"), command, false));
		builder.then(class_2170.method_9247("player_as_entity").
			then(class_2170.method_9247("disabled").executes(command)).
			then(class_2170.method_9247("enabled").
				then(class_2170.method_9244("entity", class_7733.method_45603(buildContext, class_7924.field_41266)).executes(command).
				then(class_2170.method_9244("nbt", class_2212.method_9389()).executes(command)))));
		builder.then(class_2170.method_9247("entity_filter").
			then(class_2170.method_9247("disabled").executes(command)).
			then(class_2170.method_9247("enabled").
				then(class_2170.method_9244("entity_filter", StringArgumentType.greedyString()).
					suggests(CommandSuggestions::entityFilter).executes(command))));

		if (isScene)
		{
			builder.then(class_2170.method_9247("subscene_name").
				then(class_2170.method_9244("new_name", StringArgumentType.string()).
					suggests(CommandSuggestions::playable).executes(command)));
		}
		return builder;
	}

	public static Command<class_2168> command(Function<FullCommandInfo, Boolean> function)
	{
		return (ctx) -> (function.apply(new FullCommandInfo(ctx)) ? 1 : 0);
	}

	public static RequiredArgumentBuilder<class_2168, String> withStringArgument(BiFunction<FullCommandInfo, String, Boolean> function, String arg)
	{
		return class_2170.method_9244(arg, StringArgumentType.string()).executes((ctx) -> stringCommand(function, ctx, arg, false));
	}

	public static RequiredArgumentBuilder<class_2168, String> withInputArgument(BiFunction<FullCommandInfo, String, Boolean> function, SuggestionProvider<class_2168> suggestions, String arg)
	{
		return withStringArgument(function, arg).suggests(suggestions);
	}

	public static RequiredArgumentBuilder<class_2168, String> withInputAndStringArgument(TriFunction<FullCommandInfo, String, String, Boolean> function,
																								 SuggestionProvider<class_2168> suggestions, String arg1, String arg2)
	{
		return class_2170.method_9244(arg1, StringArgumentType.string())
				.suggests(suggestions)
				.then(class_2170.method_9244(arg2, StringArgumentType.string())
				.executes((ctx) -> twoStringCommand(function, ctx, arg1, arg2)));
	}

	public static RequiredArgumentBuilder<class_2168, String> withTwoInputArguments(TriFunction<FullCommandInfo, String, String, Boolean> function,
																							SuggestionProvider<class_2168> suggestions1,
																							SuggestionProvider<class_2168> suggestions2,
																							String arg1, String arg2)
	{
		return class_2170.method_9244(arg1, StringArgumentType.string())
				.suggests(suggestions1)
				.then(class_2170.method_9244(arg2, StringArgumentType.string())
				.suggests(suggestions2)
				.executes((ctx) -> twoStringCommand(function, ctx, arg1, arg2)));
	}

	private static int stringCommand(BiFunction<FullCommandInfo, String, Boolean> function, CommandContext<class_2168> ctx, String arg, boolean nullable)
	{
		FullCommandInfo info = new FullCommandInfo(ctx);
		try
		{
			String str = info.getString(arg);
			return function.apply(info, str) ? 1 : 0;
		}
		catch (IllegalArgumentException e)
		{
			if (nullable)
			{
				return function.apply(info, null) ? 1 : 0;
			}
			else
			{
				info.sendException(e, "error.unable_to_get_argument");
				return 0;
			}
		}
	}

	private static int twoStringCommand(TriFunction<FullCommandInfo, String, String, Boolean> function, CommandContext<class_2168> ctx, String arg1, String arg2)
	{
		FullCommandInfo info = new FullCommandInfo(ctx);
		try
		{
			String str1 = info.getString(arg1);
			String str2 = info.getString(arg2);
			return function.apply(info, str1, str2) ? 1 : 0;
		}
		catch (IllegalArgumentException e)
		{
			info.sendException(e, "error.unable_to_get_argument");
			return 0;
		}
	}

	public static Pair<String, @Nullable String> splitIdStr(String str)
	{
		int dashPos = str.indexOf('-');
		int pos = Integer.parseInt(dashPos != -1 ? str.substring(0, dashPos) : str);
		String expectedName = dashPos != -1 ? str.substring(dashPos + 1) : null;
		return Pair.of(Integer.toString(pos), expectedName);
	}

	public static Pair<Integer, @Nullable String> splitPosStr(String str)
	{
		int dashPos = str.indexOf('-');
		int pos = Integer.parseInt(dashPos != -1 ? str.substring(0, dashPos) : str);
		String expectedName = dashPos != -1 ? str.substring(dashPos + 1) : null;
		return Pair.of(pos, expectedName);
	}

	public static @Nullable String getNode(List<? extends ParsedCommandNode<?>> nodes, int pos)
	{
		int size = nodes.size();
		if (pos < 0) { pos += size; }
		if (pos >= size || pos < 0) { return null; }
		return nodes.get(pos).getNode().getName();
	}

	public interface TriFunction<T, U, V, R>
	{
		R apply(T t, U u, V v);
	}
}
