package net.mt1006.mocap.command.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_7157;
import net.mt1006.mocap.MocapMod;
import net.mt1006.mocap.api.v1.io.CommandOutput;
import net.mt1006.mocap.command.CommandUtils;

public class MocapCommand
{
	public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 buildContext)
	{
		LiteralArgumentBuilder<class_2168> commandBuilder = class_2170.method_9247("mocap").requires(source -> source.method_9259(2));

		commandBuilder.then(RecordingCommand.getArgumentBuilder());
		commandBuilder.then(PlaybackCommand.getArgumentBuilder(buildContext));
		commandBuilder.then(RecordingsCommand.getArgumentBuilder());
		commandBuilder.then(ScenesCommand.getArgumentBuilder(buildContext));
		commandBuilder.then(SettingsCommand.getArgumentBuilder());
		commandBuilder.then(MiscCommand.getArgumentBuilder());
		commandBuilder.then(class_2170.method_9247("info").executes(CommandUtils.command(MocapCommand::info)));
		commandBuilder.then(class_2170.method_9247("help").executes(CommandUtils.command(MocapCommand::help)));

		dispatcher.register(commandBuilder);
	}

	private static boolean info(CommandOutput out)
	{
		out.sendSuccessLiteral(MocapMod.getFullName());
		out.sendSuccessLiteral("Author: mt1006");
		return true;
	}

	private static boolean help(CommandOutput out)
	{
		return out.sendSuccess("help", MocapMod.getName());
	}
}
