package net.mt1006.mocap.command.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.mt1006.mocap.api.v1.io.CommandInfo;
import net.mt1006.mocap.api.v1.io.CommandOutput;
import net.mt1006.mocap.command.CommandSuggestions;
import net.mt1006.mocap.command.CommandUtils;
import net.mt1006.mocap.mocap.files.RecordingFiles;
import net.mt1006.mocap.mocap.playing.playable.RecordingFile;
import net.mt1006.mocap.utils.Utils;

import java.util.List;

public class RecordingsCommand
{
	public static LiteralArgumentBuilder<class_2168> getArgumentBuilder()
	{
		LiteralArgumentBuilder<class_2168> commandBuilder = class_2170.method_9247("recordings");

		commandBuilder.then(class_2170.method_9247("copy").then(CommandUtils.withInputAndStringArgument(RecordingsCommand::copy, CommandSuggestions::recording, "src_name", "dest_name")));
		commandBuilder.then(class_2170.method_9247("rename").then(CommandUtils.withInputAndStringArgument(RecordingsCommand::rename, CommandSuggestions::recording, "old_name", "new_name")));
		commandBuilder.then(class_2170.method_9247("remove").then(CommandUtils.withInputArgument(RecordingsCommand::remove, CommandSuggestions::recording, "name")));
		commandBuilder.then(class_2170.method_9247("info").then(CommandUtils.withInputArgument(RecordingsCommand::info, CommandSuggestions::recording, "name")));
		commandBuilder.then(class_2170.method_9247("list").executes(CommandUtils.command(RecordingsCommand::list)));

		return commandBuilder;
	}

	public static boolean copy(CommandOutput out, String srcName, String destName)
	{
		RecordingFile srcFile = RecordingFile.get(out, srcName);
		RecordingFile destFile = RecordingFile.get(out, destName);
		if (srcFile == null || destFile == null) { return false; }

		return srcFile.copy(out, destFile) != null;
	}

	public static boolean rename(CommandOutput out, String srcName, String destName)
	{
		RecordingFile srcFile = RecordingFile.get(out, srcName);
		RecordingFile destFile = RecordingFile.get(out, destName);
		if (srcFile == null || destFile == null) { return false; }

		return srcFile.rename(out, destFile) != null;
	}

	public static boolean remove(CommandOutput out, String name)
	{
		RecordingFile file = RecordingFile.get(out, name);
		return file != null && file.remove(out);
	}

	public static boolean info(CommandInfo info, String name)
	{
		return RecordingFiles.info(info, RecordingFile.get(info, name));
	}

	public static boolean list(CommandOutput out)
	{
		StringBuilder recordingsListStr = new StringBuilder();
		List<String> recordingsList = RecordingFiles.list();

		if (recordingsList == null)
		{
			recordingsListStr.append(" ").append(Utils.stringFromComponent("list.error"));
		}
		else if (!recordingsList.isEmpty())
		{
			recordingsList.forEach((name) -> recordingsListStr.append(" ").append(name));
		}
		else
		{
			recordingsListStr.append(" ").append(Utils.stringFromComponent("list.empty"));
		}

		return out.sendSuccess("recordings.list", new String(recordingsListStr));
	}
}
