package net.mt1006.mocap.command.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.mt1006.mocap.command.CommandUtils;
import net.mt1006.mocap.command.io.FullCommandInfo;
import net.mt1006.mocap.mocap.settings.SettingFields;
import net.mt1006.mocap.mocap.settings.SettingGroups;
import net.mt1006.mocap.mocap.settings.Settings;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;

public class SettingsCommand
{
	private static final Command<class_2168> COMMAND_INFO = CommandUtils.command(Settings::info);
	private static final Command<class_2168> COMMAND_SET = CommandUtils.command(SettingsCommand::set);

	public static LiteralArgumentBuilder<class_2168> getArgumentBuilder()
	{
		LiteralArgumentBuilder<class_2168> commandBuilder = class_2170.method_9247("settings");

		for (SettingGroups.Group group : Settings.getGroups())
		{
			LiteralArgumentBuilder<class_2168> groupBuilder = class_2170.method_9247(group.name);
			addSettingArguments(groupBuilder, group.fields);
			commandBuilder.then(groupBuilder);
		}

		return commandBuilder;
	}

	private static boolean set(FullCommandInfo info)
	{
		return Settings.set(info);
	}

	private static void addSettingArguments(LiteralArgumentBuilder<class_2168> builder, Collection<SettingFields.Field<?>> fields)
	{
		fields.forEach((f) -> builder.then(settingArgument(f.name, f.getArgumentType(), f.getSuggestionProvider())));
	}

	private static LiteralArgumentBuilder<class_2168> settingArgument(String name, ArgumentType<?> argumentType,
																			  @Nullable SuggestionProvider<class_2168> suggestionProvider)
	{
		RequiredArgumentBuilder<class_2168, ?> arg = class_2170.method_9244("new_value", argumentType);
		if (suggestionProvider != null) { arg.suggests(suggestionProvider); }
		return class_2170.method_9247(name).executes(COMMAND_INFO).then(arg.executes(COMMAND_SET));
	}
}
