package net.mt1006.mocap.command.io;

import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import net.mt1006.mocap.MocapMod;
import net.mt1006.mocap.api.v1.io.CommandInfo;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

public class APICommandInfo implements CommandInfo
{
	private final MinecraftServer server;
	private final class_3218 level;
	private final String sourceName;

	public APICommandInfo(MinecraftServer server, class_3218 level, String sourceName)
	{
		this.server = server;
		this.level = level;
		this.sourceName = "+" + sourceName;
	}

	@Override public boolean sendSuccess(String component, Object... args) { return true; }
	@Override public boolean sendSuccessLiteral(String format, Object... args) { return true; }
	@Override public boolean sendSuccessComponent(class_2561 component) { return true; }

	@Override public boolean sendFailure(String component, Object... args)
	{
		// unlike with LogsCommandOutput failures can be caused by using API, so it's warning, not error
		MocapMod.LOGGER.warn(Utils.stringFromComponent(component, args));
		return false;
	}

	@Override public boolean sendFailureWithTip(String component, Object... args)
	{
		MocapMod.LOGGER.warn(Utils.stringFromComponent(component, args));
		return false;
	}

	@Override public boolean sendException(Exception exception, String component, Object... args)
	{
		Utils.exception(exception, Utils.stringFromComponent(component, args));
		return false;
	}

	@Override public MinecraftServer getServer()
	{
		return server;
	}

	@Override public class_3218 getLevel()
	{
		return level;
	}

	@Override public @Nullable class_3222 getSourcePlayer()
	{
		return null;
	}

	@Override public @Nullable class_1297 getSourceEntity()
	{
		return null;
	}

	@Override public String getSourceName()
	{
		return sourceName;
	}
}
