package net.mt1006.mocap.command.io;

import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2212;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7733;
import net.minecraft.server.MinecraftServer;
import net.mt1006.mocap.api.v1.io.CommandInfo;
import net.mt1006.mocap.api.v1.io.CommandOutput;
import net.mt1006.mocap.api.v1.modifiers.MocapModifiers;
import net.mt1006.mocap.api.v1.modifiers.MocapPlayerAsEntity;
import net.mt1006.mocap.api.v1.modifiers.MocapPlayerSkin;
import net.mt1006.mocap.command.CommandUtils;
import net.mt1006.mocap.mocap.playing.modifiers.PlaybackModifiers;
import net.mt1006.mocap.mocap.playing.modifiers.PlayerAsEntity;
import net.mt1006.mocap.mocap.playing.modifiers.PlayerSkin;
import net.mt1006.mocap.mocap.settings.Settings;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

public class FullCommandInfo implements CommandInfo
{
	public final CommandContext<class_2168> ctx;
	public final class_2168 source;
	private final MinecraftServer server;
	private final class_3218 level;
	private final @Nullable class_3222 sourcePlayer;
	private final @Nullable class_1297 sourceEntity;

	public FullCommandInfo(CommandContext<class_2168> ctx)
	{
		this.ctx = ctx;
		this.source = ctx.getSource();
		this.server = source.method_9211();
		this.level = source.method_9225();
		this.sourcePlayer = source.method_44023();
		this.sourceEntity = source.method_9228();
	}

	@Override public boolean sendSuccess(String component, Object... args)
	{
		source.method_9226(() -> getTranslatableComponent(component, args), false);
		return true;
	}

	@Override public boolean sendSuccessLiteral(String format, Object... args)
	{
		source.method_9226(() -> class_2561.method_43470(String.format(format, args)), false);
		return true;
	}

	@Override public boolean sendSuccessComponent(class_2561 component)
	{
		source.method_9226(() -> component, false);
		return true;
	}

	@Override public boolean sendFailure(String component, Object... args)
	{
		source.method_9213(getTranslatableComponent(component, args));
		return false;
	}

	@Override public boolean sendFailureWithTip(String component, Object... args)
	{
		source.method_9213(getTranslatableComponent(component, args));
		if (Settings.SHOW_TIPS.val) { source.method_9213(getTranslatableComponent(component + ".tip")); }
		return false;
	}

	@Override public boolean sendException(Exception exception, String component, Object... args)
	{
		sendFailure(component, args);
		Utils.exception(exception, Utils.stringFromComponent(component, args));
		return false;
	}

	@Override public MinecraftServer getServer()
	{
		return server;
	}

	@Override public class_3218 getLevel()
	{
		return level;
	}

	@Override public @Nullable class_3222 getSourcePlayer()
	{
		return sourcePlayer;
	}

	@Override public @Nullable class_1297 getSourceEntity()
	{
		return sourceEntity;
	}

	@Override public String getSourceName()
	{
		return sourcePlayer != null ? sourcePlayer.method_5477().getString() : "+mc";
	}

	public @Nullable FullCommandInfo getFinalCommandInfo()
	{
		CommandContext<class_2168> tempCtx = ctx;
		while (true)
		{
			String command = CommandUtils.getNode(tempCtx.getNodes(), 0);
			if (command != null && (command.equals("mocap") || command.equals("mocap:mocap"))) { return new FullCommandInfo(tempCtx); }

			tempCtx = ctx.getChild();
			if (tempCtx == null) { return null; }
		}
	}

	public @Nullable String getNode(int pos)
	{
		return CommandUtils.getNode(ctx.getNodes(), pos);
	}

	public int getInteger(String name)
	{
		return IntegerArgumentType.getInteger(ctx, name);
	}

	public double getDouble(String name)
	{
		return DoubleArgumentType.getDouble(ctx, name);
	}

	public boolean getBool(String name)
	{
		return BoolArgumentType.getBool(ctx, name);
	}

	public String getString(String name)
	{
		return StringArgumentType.getString(ctx, name);
	}

	public @Nullable String getNullableString(String name)
	{
		try { return StringArgumentType.getString(ctx, name); }
		catch (Exception e) { return null; }
	}

	public @Nullable MocapPlayerSkin getPlayerSkin()
	{
		String fromPlayer = getNullableString("skin_player_name");
		if (fromPlayer != null) { return PlayerSkin.createVerified(this, MocapPlayerSkin.Source.FROM_PLAYER, fromPlayer); }

		String fromFile = getNullableString("skin_filename");
		if (fromFile != null) { return PlayerSkin.createVerified(this, MocapPlayerSkin.Source.FROM_FILE, fromFile); }

		String fromMineskin = getNullableString("mineskin_url");
		if (fromMineskin != null) { return PlayerSkin.createVerified(this, MocapPlayerSkin.Source.FROM_MINESKIN, fromMineskin); }

		return PlayerSkin.DEFAULT;
	}

	public @Nullable MocapModifiers getSimpleModifiers(CommandOutput out)
	{
		String playerName = getNullableString("player_name");
		if (!PlaybackModifiers.checkIfProperPlayerName(out, playerName)) { return null; }

		MocapPlayerSkin playerSkin = getPlayerSkin();
		if (playerSkin == null) { return null; }

		MocapPlayerAsEntity playerAsEntity = PlayerAsEntity.DISABLED;

		try
		{
			String playerAsEntityId = class_7733.method_45609(ctx, "entity").method_40237().method_29177().toString();

			class_2520 tag;
			try { tag = class_2212.method_9390(ctx, "nbt"); }
			catch (Exception e) { tag = null; }
			class_2487 nbt = (tag instanceof class_2487) ? (class_2487)tag : null;

			playerAsEntity = new PlayerAsEntity(playerAsEntityId, nbt != null ? nbt.toString() : null);
		}
		catch (Exception ignore) {}

		return PlaybackModifiers.DEFAULT.withPlayerName(playerName).withPlayerSkin(playerSkin).withPlayerAsEntity(playerAsEntity);
	}
}
