package net.mt1006.mocap.events;

import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1733;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.mt1006.mocap.mocap.actions.*;
import net.mt1006.mocap.mocap.recording.RecordingManager;

public class BlockInteractionEvent
{
	public static void onBlockBreak(class_1657 player, class_2338 pos, class_2680 blockState)
	{
		if (RecordingManager.isActive())
		{
			RecordingManager.byRecordedPlayer(player).forEach((ctx) -> ctx.addAction(new BreakBlock(blockState, pos)));
		}
	}

	public static void onBlockPlace(class_1657 player, class_2680 replacedBlock, class_2680 placedBlock, class_2338 blockPos)
	{
		if (RecordingManager.isActive())
		{
			RecordingManager.byRecordedPlayer(player).forEach((ctx) -> ctx.addAction(new PlaceBlock(replacedBlock, placedBlock, blockPos)));
		}
	}

	public static void onSilentBlockPlace(class_1657 player, class_2680 replacedBlock, class_2680 placedBlock, class_2338 blockPos)
	{
		if (RecordingManager.isActive())
		{
			RecordingManager.byRecordedPlayer(player).forEach((ctx) -> ctx.addAction(new PlaceBlockSilently(replacedBlock, placedBlock, blockPos)));
		}
	}

	public static void onRightClickBlock(class_1657 player, class_1268 hand, class_3965 hitResult, boolean doesSneakBypassUse)
	{
		if (RecordingManager.isActive() && !usedOnShift(player, doesSneakBypassUse))
		{
			boolean isOffHand = (hand == class_1268.field_5810);
			RecordingManager.byRecordedPlayer(player).forEach((ctx) -> ctx.addAction(new RightClickBlock(hitResult, isOffHand)));
		}
	}

	public static void onContainerClose(class_1657 player, class_1703 container)
	{
		if (RecordingManager.isActive() && (container instanceof class_1707 || container instanceof class_1733))
		{
			RecordingManager.byRecordedPlayer(player).forEach((ctx) -> ctx.addAction(CloseContainer.INSTANCE));
		}
	}

	private static boolean usedOnShift(class_1657 player, boolean doesSneakBypassUse)
	{
		return player.method_21823()
				&& (!player.method_6047().method_7960() || !player.method_6079().method_7960())
				&& !doesSneakBypassUse;
	}
}
