package net.mt1006.mocap.events;

import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.mt1006.mocap.mocap.actions.EntityUpdate;
import net.mt1006.mocap.mocap.actions.Hurt;
import net.mt1006.mocap.mocap.playing.PlaybackManager;
import net.mt1006.mocap.mocap.recording.RecordingManager;

public class EntityEvent
{
	public static void onEntityHurt(class_1309 entity)
	{
		if (RecordingManager.isActive() && entity.method_73183() instanceof class_3218)
		{
			RecordingManager.byRecordedPlayer(entity).forEach((ctx) -> ctx.addAction(Hurt.INSTANCE));
			RecordingManager.listTrackedEntities(entity).forEach((e) -> e.getParent().addAction(EntityUpdate.hurt(e.getId())));
		}
	}

	public static boolean onEntityDrop(class_1309 entity)
	{
		return !PlaybackManager.playbacks.isEmpty() && entity.method_5752().contains(PlaybackManager.MOCAP_ENTITY_TAG);
	}

	public static void onPlayerRespawn(class_3222 oldPlayer, class_3222 newPlayer)
	{
		if (!RecordingManager.isActive() && !RecordingManager.waitingForRespawn.isEmpty()) { RecordingManager.waitingForRespawn.clear(); }
		if (RecordingManager.waitingForRespawn.isEmpty()) { return; }

		RecordingManager.waitingForRespawn.byKey.get(oldPlayer).forEach((ctx) -> ctx.onRespawn(newPlayer));
		RecordingManager.waitingForRespawn.byKey.removeAll(oldPlayer);
	}
}
