package net.mt1006.mocap.mixin;

import com.mojang.authlib.properties.Property;
import net.minecraft.class_12079;
import net.minecraft.class_640;
import net.minecraft.class_742;
import net.minecraft.class_7920;
import net.minecraft.class_8685;
import net.mt1006.mocap.mocap.playing.skins.CustomClientSkinManager;
import net.mt1006.mocap.mocap.playing.skins.CustomServerSkinManager;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Collection;

@Mixin(class_742.class)
public abstract class AbstractClientPlayerMixin
{
	@Shadow protected abstract @Nullable class_640 getPlayerInfo();

	@Inject(method = "getSkin", at = @At(value = "HEAD"), cancellable = true)
	private void atGetSkinTextureLocation(CallbackInfoReturnable<class_8685> cir)
	{
		class_640 playerInfo = getPlayerInfo();
		if (playerInfo == null) { return; }

		Collection<Property> properties = playerInfo.method_2966().properties().get(CustomServerSkinManager.PROPERTY_ID);
		if (properties.isEmpty()) { return; }

		class_12079.class_12081 skinTexture = CustomClientSkinManager.get(properties.iterator().next().value());
		if (skinTexture == null) { return; }

		class_8685 playerSkin = playerInfo.method_52810();

		cir.setReturnValue(new class_8685(skinTexture, playerSkin.comp_1627(), playerSkin.comp_1628(),
				CustomClientSkinManager.isSlimSkin(skinTexture) ? class_7920.field_41122 : class_7920.field_41123,
				playerSkin.comp_1630()));
		cir.cancel();
	}
}
