package net.mt1006.mocap.mocap.actions;

import net.minecraft.class_2338;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapActionContext;
import net.mt1006.mocap.api.v1.extension.actions.MocapBasicActionContext;
import net.mt1006.mocap.api.v1.extension.actions.MocapBlockAction;

import java.util.List;

public class BreakBlockProgress implements MocapBlockAction
{
	private final class_2338 blockPos;
	private final int progress;

	public BreakBlockProgress(class_2338 blockPos, int progress)
	{
		this.blockPos = blockPos;
		this.progress = progress;
	}

	public BreakBlockProgress(Reader reader)
	{
		this.blockPos = reader.readBlockPos();
		this.progress = reader.readInt();
	}

	@Override public void write(Writer writer, MocapRecordingData data)
	{
		writer.addBlockPos(blockPos);
		writer.addInt(progress);
	}

	@Override public void initBlocks(MocapBasicActionContext ctx) {}

	@Override public Result execute(MocapActionContext ctx)
	{
		List<? extends class_2338> blocks = ctx.getTransformer().transformBlockPos(blockPos, ctx.getConfig().getBlockAllowScaled());
		if (!blocks.isEmpty()) { ctx.getLevel().method_8517(ctx.getEntity().method_5628(), blocks.get(0), progress); }
		return Result.OK;
	}
}
