package net.mt1006.mocap.mocap.actions;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import net.minecraft.class_1297;
import net.minecraft.class_4050;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapActionContext;
import net.mt1006.mocap.api.v1.extension.actions.MocapStateAction;

import java.util.EnumMap;

public class ChangePose implements MocapStateAction
{
	private static final BiMap<Integer, class_4050> poseMap;
	private static final BiMap<class_4050, Integer> poseIdMap;
	static
	{
		EnumMap<class_4050, Integer> enumMap = new EnumMap<>(class_4050.class);
		enumMap.put(class_4050.field_18076, 1);
		enumMap.put(class_4050.field_18077, 2);
		enumMap.put(class_4050.field_18078, 3);
		enumMap.put(class_4050.field_18079, 4);
		enumMap.put(class_4050.field_18080, 5);
		enumMap.put(class_4050.field_18081, 6);
		enumMap.put(class_4050.field_18082, 7);
		enumMap.put(class_4050.field_30095, 8);
		enumMap.put(class_4050.field_37422, 9);
		enumMap.put(class_4050.field_37423, 10);
		enumMap.put(class_4050.field_40118, 11);
		enumMap.put(class_4050.field_38097, 12);
		enumMap.put(class_4050.field_38098, 13);
		enumMap.put(class_4050.field_38099, 14);
		enumMap.put(class_4050.field_38100, 15);
		enumMap.put(class_4050.field_47246, 16);
		enumMap.put(class_4050.field_47247, 17);
		enumMap.put(class_4050.field_47248, 18);

		poseIdMap = HashBiMap.create(enumMap);
		poseMap = poseIdMap.inverse();
	}

	private final class_4050 pose;

	public ChangePose(class_1297 entity)
	{
		pose = entity.method_18376();
	}

	public ChangePose(Reader reader)
	{
		pose = poseMap.getOrDefault(reader.readInt(), class_4050.field_18076);
	}

	@Override public boolean differs(MocapStateAction previousAction)
	{
		return pose != ((ChangePose)previousAction).pose;
	}

	@Override public void write(Writer writer, MocapRecordingData data)
	{
		writer.addInt(poseIdMap.getOrDefault(pose, 0));
	}

	@Override public Result execute(MocapActionContext ctx)
	{
		ctx.getEntity().method_18380(pose);
		return Result.OK;
	}
}
