package net.mt1006.mocap.mocap.actions;

import com.google.gson.JsonParser;
import com.mojang.serialization.JsonOps;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7471;
import net.minecraft.class_8824;
import net.minecraft.server.MinecraftServer;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapActionContext;

import java.util.List;
import java.util.UUID;

public class ChatMessage implements MocapAction
{
	private final String messageJson;

	public ChatMessage(class_2561 component)
	{
		String message;
		try { message = class_8824.field_46597.encodeStart(JsonOps.INSTANCE, component).getOrThrow().toString(); }
		catch (IllegalStateException e) { message = "{}"; }
		this.messageJson = message;
	}

	//TODO: [CONVERTER] remove
	public ChatMessage(String messageJson)
	{
		this.messageJson = messageJson;
	}

	public ChatMessage(Reader reader)
	{
		reader.readByte(); // ignored
		this.messageJson = reader.readString();
	}

	@Override public void write(Writer writer, MocapRecordingData data)
	{
		writer.addByte((byte)0); // dummy value - for future uses
		writer.addString(messageJson);
	}

	@Override public Result execute(MocapActionContext ctx)
	{
		if (!ctx.getConfig().getChatPlayback()) { return Result.IGNORED; }
		class_3222 player = ctx.getRealOrDummyPlayer();
		if (player == null) { return Result.IGNORED; }

		MinecraftServer server = ctx.getLevel().method_8503();
		class_2561 message;
		try { message = class_8824.field_46597.decode(JsonOps.INSTANCE, new JsonParser().parse(messageJson)).getOrThrow().getFirst(); }
		catch (Exception e) { return Result.IGNORED; }
		if (message == null) { return Result.IGNORED; }

		UUID senderUUID;
		if (player != ctx.getEntity())
		{
			// get UUID of any player, because dummy players are only on a server
			List<class_3222> playerList = ctx.getLevel().method_8503().method_3760().method_14571();
			if (playerList.isEmpty()) { return Result.IGNORED; }
			senderUUID = playerList.get(0).method_5667();
		}
		else
		{
			senderUUID = player.method_5667();
		}

		class_7471 chatMessage = class_7471.method_45098(senderUUID, message.getString()).method_44863(message);
		server.method_3760().method_43673(chatMessage, player, class_2556.method_44832(class_2556.field_11737, player));
		return Result.OK;
	}
}
