package net.mt1006.mocap.mocap.actions;

import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3730;
import net.minecraft.class_5134;
import net.minecraft.class_8942;
import net.minecraft.world.entity.*;
import net.mt1006.mocap.api.v1.controller.config.MocapNbtRecordingMode;
import net.mt1006.mocap.api.v1.controller.config.MocapRecordingConfig;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapActionContext;
import net.mt1006.mocap.api.v1.modifiers.MocapEntityFilter;
import net.mt1006.mocap.command.converter.AlphaConverter;
import net.mt1006.mocap.mixin.fields.EntityIdFields;
import net.mt1006.mocap.mocap.playing.PlaybackManager;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

public class EntityUpdate implements MocapAction
{
	private final UpdateType type;
	private final int id;
	private final @Nullable String nbtString;
	private final @Nullable class_243 position;

	public static EntityUpdate addEntity(int id, class_1297 entity, MocapRecordingConfig config)
	{
		String nbtString = serializeEntityNBT(entity, config).toString();
		return new EntityUpdate(UpdateType.ADD, id, nbtString, entity.method_73189());
	}

	public static EntityUpdate removeEntity(int id)
	{
		return new EntityUpdate(UpdateType.REMOVE, id, null, null);
	}

	public static EntityUpdate kill(int id)
	{
		return new EntityUpdate(UpdateType.KILL, id, null, null);
	}

	public static EntityUpdate hurt(int id)
	{
		return new EntityUpdate(UpdateType.HURT, id, null, null);
	}

	public static EntityUpdate playerMount(int id)
	{
		return new EntityUpdate(UpdateType.PLAYER_MOUNT, id, null, null);
	}

	public static EntityUpdate playerDismount()
	{
		return new EntityUpdate(UpdateType.PLAYER_DISMOUNT, 0, null, null);
	}

	private EntityUpdate(UpdateType type, int id, @Nullable String nbtString, @Nullable class_243 position)
	{
		this.type = type;
		this.id = id;
		this.nbtString = nbtString;
		this.position = position;
	}

	//TODO: [CONVERTER] remove
	public EntityUpdate(Reader reader)
	{
		this(reader, null, 0);
	}

	//TODO: [CONVERTER] remove two last args
	public EntityUpdate(Reader reader, @Nullable AlphaConverter converter, int dummy)
	{
		type = UpdateType.fromId(reader.readByte());
		id = reader.readInt();

		if (type == UpdateType.ADD)
		{
			nbtString = reader.readString();
			position = reader.readVec3();

			//TODO: [CONVERTER] remove
			if (converter != null)
			{
				converter.posByEntity.put(id, new double[]{position.field_1352, position.field_1351, position.field_1350});
			}
		}
		else
		{
			nbtString = null;
			position = null;
		}
	}

	public static class_2487 serializeEntityNBT(class_1297 entity, MocapRecordingConfig config)
	{
		class_11362 tagOutput = class_11362.method_71459(class_8942.field_60348, entity.method_56673());

		String id = ((EntityIdFields)entity).callGetEncodeId();
		tagOutput.method_71469("id", id != null ? id : "minecraft:cow");
		if (config.getNbtRecordingMode() != MocapNbtRecordingMode.DISABLED) entity.method_5647(tagOutput);

		class_2487 nbt = tagOutput.method_71475();
		nbt.method_10551("UUID");
		nbt.method_10551("Pos");
		nbt.method_10551("Motion");

		if (config.getNbtRecordingMode() == MocapNbtRecordingMode.FILTERED) { filterEntityNBT(nbt, entity); }
		return nbt;
	}

	public static void filterEntityNBT(class_2487 nbt, class_1297 entity)
	{
		nbt.method_10551("Brain");
		nbt.method_10551("EggLayTime");
		nbt.method_10551("CanPickUpLoot");
		nbt.method_10551("NoAI");
		nbt.method_10551("ForcedAge");
		nbt.method_10551("EggLayTime");
		nbt.method_10551("fall_distance");
		if (nbt.method_68565("HurtTime", (short)-1) == 0) { nbt.method_10551("HurtTime"); }
		if (nbt.method_68565("DeathTime", (short)-1) == 0) { nbt.method_10551("DeathTime"); }
		if (nbt.method_68083("HurtByTimestamp", -1) == 0) { nbt.method_10551("HurtByTimestamp"); }
		if (nbt.method_68565("Air", (short)-1) == entity.method_5748()) { nbt.method_10551("Air"); }
		if (nbt.method_66563("AbsorptionAmount", -1.0f) == 0.0f) { nbt.method_10551("AbsorptionAmount"); }
		if (entity instanceof class_1309 living && nbt.method_66563("Health", -1.0f) == living.method_6063()) { nbt.method_10551("Health"); }

		if (nbt.method_68083("Age", -1) >= 0) { nbt.method_10551("Age"); }
		else { nbt.method_10569("Age", -9); } // -9 is short in string form and is enough time for playback to set IS_BABY flag

		class_2499 listTag = nbt.method_10554("attributes").orElse(null);
		if (listTag != null)
		{
			class_2499 newListTag = new class_2499();
			for (class_2520 tag : listTag)
			{
				class_2487 attribute = tag.method_68571().orElse(null);
				String attributeIdStr = attribute != null ? attribute.method_10558("id").orElse(null) : null;
				class_2960 attributeId = attributeIdStr != null ? class_2960.method_12829(attributeIdStr) : null;

				if (attributeId == null)
				{
					// this means attribute list is broken, but keep it anyway
					newListTag.add(tag);
					continue;
				}

				if (class_5134.field_23717.method_40226(attributeId)) { continue; }
				if (class_5134.field_23721.method_40226(attributeId)) { continue; }
				if (class_5134.field_49077.method_40226(attributeId)) { continue; }
				if (class_5134.field_49079.method_40226(attributeId)) { continue; }
				newListTag.add(tag);
			}

			if (newListTag.isEmpty()) { nbt.method_10551("attributes"); }
			else { nbt.method_10566("attributes", newListTag); }
		}
	}

	@Override public void write(Writer writer, MocapRecordingData data)
	{
		writer.addByte(type.id);
		writer.addInt(id);

		if (type == UpdateType.ADD)
		{
			writer.addString(nbtString != null ? nbtString : "");
			writer.addVec3(position != null ? position : class_243.field_1353);
		}
	}

	@Override public Result execute(MocapActionContext ctx)
	{
		switch (type)
		{
			case ADD:
				return executeAdd(ctx);

			case PLAYER_DISMOUNT:
				ctx.getEntity().method_5848();
				return Result.OK;

			case NONE:
				return Result.IGNORED;
		}

		MocapActionContext.EntityData entityData = ctx.getEntityData(id);
		if (entityData == null) { return Result.IGNORED; }
		class_1297 entity = entityData.entity;

		switch (type)
		{
			case REMOVE:
				entity.method_5650(class_1297.class_5529.field_26998);
				return Result.OK;

			case KILL:
				//TODO: fix slime splitting into dummy slimes
				entity.field_6008 = 0; // for sound effect
				entity.method_5768(ctx.getLevel());
				return Result.OK;

			case HURT:
				Hurt.hurtEntity(entity, ctx.getConfig());
				return Result.OK;

			case PLAYER_MOUNT:
				ctx.getEntity().method_5873(entity, true, true);
				return Result.OK;
		}
		return Result.IGNORED;
	}

	private Result executeAdd(MocapActionContext ctx)
	{
		MocapEntityFilter filter = ctx.getModifiers().getEntityFilter();
		if (nbtString == null || position == null || ctx.hasEntity(id) || filter.isEmpty()) { return Result.IGNORED; }

		class_2487 compoundTag;
		try
		{
			compoundTag = Utils.nbtFromString(nbtString);
		}
		catch (Exception e)
		{
			Utils.exception(e, "Exception occurred when parsing entity NBT data!");
			return Result.ERROR;
		}
		class_11368 nbt = class_11352.method_71417(class_8942.field_60348, ctx.getEntity().method_56673(), compoundTag);

		class_1297 entity = class_1299.method_5892(nbt, ctx.getLevel(), class_3730.field_16471).orElse(null);
		if (entity == null || !filter.isAllowed(entity)) { return Result.IGNORED; }

		entity.method_33574(ctx.getTransformer().transformPos(position));
		entity.method_18800(0.0, 0.0, 0.0);
		entity.method_5875(true);
		entity.method_5684(ctx.getConfig().getInvulnerablePlayback());
		entity.method_5780(PlaybackManager.MOCAP_ENTITY_TAG);
		if (entity instanceof class_1308) { ((class_1308)entity).method_5977(true); }
		ctx.getModifiers().getTransformations().applyScaleToEntity(entity);

		ctx.getLevel().method_8649(entity);
		ctx.addEntity(id, entity, position);
		return Result.OK;
	}

	public enum UpdateType
	{
		NONE(0),
		ADD(1),
		REMOVE(2),
		KILL(3),
		HURT(4),
		PLAYER_MOUNT(5),
		PLAYER_DISMOUNT(6);

		private static final UpdateType[] VALUES = values();
		private final byte id;

		UpdateType(int id)
		{
			this.id = (byte)id;
		}

		private static UpdateType fromId(byte id)
		{
			for (UpdateType type : VALUES)
			{
				if (type.id == id) { return type; }
			}
			return NONE;
		}
	}
}
