package net.mt1006.mocap.mocap.actions;

import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapActionContext;
import net.mt1006.mocap.api.v1.extension.actions.MocapStateAction;
import org.jetbrains.annotations.Nullable;

public class SetArrowCount implements MocapStateAction
{
	private final int arrowCount;
	private final int beeStingerCount;

	public static @Nullable SetArrowCount fromEntity(class_1297 entity)
	{
		return (entity instanceof class_1309 livingEntity) ? new SetArrowCount(livingEntity) : null;
	}

	private SetArrowCount(class_1309 entity)
	{
		arrowCount = entity.method_6022();
		beeStingerCount = entity.method_21753();
	}

	public SetArrowCount(Reader reader)
	{
		arrowCount = reader.readInt();
		beeStingerCount = reader.readInt();
	}

	@Override public boolean differs(MocapStateAction previousAction)
	{
		return arrowCount != ((SetArrowCount)previousAction).arrowCount
				|| beeStingerCount != ((SetArrowCount)previousAction).beeStingerCount;
	}

	@Override public boolean shouldBeInitialized()
	{
		return arrowCount != 0 || beeStingerCount != 0;
	}

	@Override public void write(Writer writer, MocapRecordingData data)
	{
		writer.addInt(arrowCount);
		writer.addInt(beeStingerCount);
	}

	@Override public Result execute(MocapActionContext ctx)
	{
		if (!(ctx.getEntity() instanceof class_1309)) { return Result.IGNORED; }
		((class_1309)ctx.getEntity()).method_6097(arrowCount);
		((class_1309)ctx.getEntity()).method_21755(beeStingerCount);
		return Result.OK;
	}
}
