package net.mt1006.mocap.mocap.actions;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.JsonOps;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapActionContext;
import net.mt1006.mocap.api.v1.extension.actions.MocapStateAction;
import net.mt1006.mocap.utils.EntityData;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class SetEffectParticles implements MocapStateAction
{
	private final Set<String> particleJsonSet = new TreeSet<>();
	private final boolean ambience;

	public static @Nullable SetEffectParticles fromEntity(class_1297 entity)
	{
		return (entity instanceof class_1309 livingEntity) ? new SetEffectParticles(livingEntity) : null;
	}

	private SetEffectParticles(class_1309 entity)
	{
		for (class_2394 particle : EntityData.LIVING_ENTITY_EFFECT_PARTICLES.valOrDef(entity, List.of()))
		{
			JsonElement jsonElement = class_2398.field_25125.encodeStart(JsonOps.INSTANCE, particle).result().orElse(null);
			if (jsonElement == null) { continue; }

			particleJsonSet.add(jsonElement.toString());
		}

		this.ambience = EntityData.LIVING_ENTITY_EFFECT_AMBIENCE.valOrDef(entity, false);
	}

	public SetEffectParticles(Reader reader)
	{
		int count = reader.readPackedInt();
		for (int i = 0; i < count; i++)
		{
			String particleJson = reader.readString();
			particleJsonSet.add(particleJson);
		}

		ambience = reader.readBoolean();
	}

	@Override public boolean differs(MocapStateAction previousAction)
	{
		return !particleJsonSet.equals(((SetEffectParticles)previousAction).particleJsonSet)
				|| ambience != ((SetEffectParticles)previousAction).ambience;
	}

	@Override public boolean shouldBeInitialized()
	{
		return !particleJsonSet.isEmpty() || ambience;
	}

	@Override public void write(Writer writer, MocapRecordingData data)
	{
		writer.addPackedInt(particleJsonSet.size());
		particleJsonSet.forEach(writer::addString);

		writer.addBoolean(ambience);
	}

	@Override public Result execute(MocapActionContext ctx)
	{
		if (!(ctx.getEntity() instanceof class_1309 entity)) { return Result.IGNORED; }

		List<class_2394> particles = new ArrayList<>();
		for (String jsonStr : particleJsonSet)
		{
			try
			{
				particles.add(class_2398.field_25125.decode(JsonOps.INSTANCE, new JsonParser().parse(jsonStr)).getOrThrow().getFirst());
			}
			catch (Exception ignore) {}
		}

		EntityData.LIVING_ENTITY_EFFECT_PARTICLES.set(entity, particles);
		EntityData.LIVING_ENTITY_EFFECT_AMBIENCE.set(ctx.getEntity(), ambience);
		return Result.OK;
	}
}
