package net.mt1006.mocap.mocap.actions;

import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1492;
import net.minecraft.class_1496;
import net.minecraft.class_1498;
import net.minecraft.class_1501;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1688;
import net.minecraft.class_1690;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_7689;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapActionContext;
import net.mt1006.mocap.api.v1.extension.actions.MocapStateAction;
import net.mt1006.mocap.mixin.fields.*;
import net.mt1006.mocap.utils.EntityData;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;

public class SetNonPlayerEntityData implements MocapStateAction
{
	private static final byte VAL_FLAG1 =  0b00000001;
	private static final byte VAL_FLAG2 =  0b00000010;
	private static final byte HAS_BYTE1 =  0b00000100;
	private static final byte HAS_INT1 =   0b00001000;
	private static final byte HAS_INT2 =   0b00010000;
	private static final byte HAS_INT3 =   0b00100000;
	private static final byte HAS_FLOAT1 = 0b01000000;

	private final boolean flag1;             // Camel - is dashing; AbstractChestedHorse - has chest; Boat - is left paddle turning; AbstractArrow - is in ground
	private final boolean flag2;             // AgeableMob - is baby; Boat - is right paddle turning
	private final @Nullable Byte byte1;      // AbstractHorse
	private final @Nullable Integer int1;    // Horse/Llama - variant; Boat - time since last hit; AbstractMinecart - shaking power
	private final @Nullable Integer int2;    // Boat - hit direction; AbstractMinecart - shaking direction
	private final @Nullable Integer int3;    // Boat - splash timer; AbstractMinecart - shaking multiplier
	private final @Nullable Float float1;    // Boat - damage taken

	public static @Nullable SetNonPlayerEntityData fromEntity(class_1297 entity)
	{
		if (entity instanceof class_1657) { return null; }

		if (entity instanceof class_1496)
		{
			boolean flag1 = false;
			boolean flag2 = ((class_1296)entity).method_5618() < 0;
			Byte byte1 = EntityData.ABSTRACT_HORSE_FLAGS.valOrDef(entity, (byte)0);
			Integer int1 = null;

			if (entity instanceof class_1498) { int1 = ((HorseFields)entity).callGetTypeVariant(); }
			else if (entity instanceof class_1492 chestedHorse) { flag1 = chestedHorse.method_6703(); }
			else if (entity instanceof class_7689 camel) { flag1 = camel.method_45361(); }

			if (entity instanceof class_1501 llama) { int1 = llama.method_6809().method_47875(); }

			return new SetNonPlayerEntityData(flag1, flag2, byte1, int1, null, null, null);
		}
		else if (entity instanceof class_1690 boat)
		{
			return new SetNonPlayerEntityData(
					boat.method_64491(0),
					boat.method_64491(1),
					null,
					boat.method_54295(),
					boat.method_54296(),
					((BoatFields)entity).callGetBubbleTime(),
					boat.method_54294());
		}
		else if (entity instanceof class_1688 minecart)
		{
			return new SetNonPlayerEntityData(
					false, false, null,
					minecart.method_54295(),
					minecart.method_54296(),
					null,
					minecart.method_54294());
		}
		else if (entity instanceof class_1665) // includes trident
		{
			boolean flag1 = ((AbstractArrowFields)entity).callIsInGround();
			return new SetNonPlayerEntityData(flag1, false, null, null, null, null, null);
		}
		else if (entity instanceof class_1296)
		{
			boolean flag2 = ((class_1296)entity).method_5618() < 0;
			return new SetNonPlayerEntityData(false, flag2, null, null, null, null, null);
		}
		else
		{
			return null;
		}
	}

	private SetNonPlayerEntityData(boolean flag1, boolean flag2, @Nullable Byte byte1, @Nullable Integer int1,
								   @Nullable Integer int2, @Nullable Integer int3, @Nullable Float float1)
	{
		this.byte1 = byte1;
		this.flag1 = flag1;
		this.flag2 = flag2;
		this.int1 = int1;
		this.int2 = int2;
		this.int3 = int3;
		this.float1 = float1;
	}

	public SetNonPlayerEntityData(MocapAction.Reader reader)
	{
		byte flags = reader.readByte();
		flag1 = (flags & VAL_FLAG1) != 0;
		flag2 = (flags & VAL_FLAG2) != 0;
		byte1 = (flags & HAS_BYTE1) != 0 ? reader.readByte() : null;
		int1 = (flags & HAS_INT1) != 0 ? reader.readPackedInt() : null;
		int2 = (flags & HAS_INT2) != 0 ? reader.readPackedInt() : null;
		int3 = (flags & HAS_INT3) != 0 ? reader.readPackedInt() : null;
		float1 = (flags & HAS_FLOAT1) != 0 ? reader.readFloat() : null;
	}

	@Override public boolean differs(MocapStateAction previousAction)
	{
		SetNonPlayerEntityData data = (SetNonPlayerEntityData)previousAction;

		return flag1 != data.flag1
				|| flag2 != data.flag2
				|| !Objects.equals(byte1, data.byte1)
				|| !Objects.equals(int1, data.int1)
				|| !Objects.equals(int2, data.int2)
				|| !Objects.equals(int3, data.int3)
				|| !Objects.equals(float1, data.float1);
	}

	@Override public void write(MocapAction.Writer writer, MocapRecordingData data)
	{
		byte flags = 0;
		flags |= flag1 ? VAL_FLAG1 : 0;
		flags |= flag2 ? VAL_FLAG2 : 0;
		flags |= byte1 != null ? HAS_BYTE1 : 0;
		flags |= int1 != null ? HAS_INT1 : 0;
		flags |= int2 != null ? HAS_INT2 : 0;
		flags |= int3 != null ? HAS_INT3 : 0;
		flags |= float1 != null ? HAS_FLOAT1 : 0;

		writer.addByte(flags);
		if (byte1 != null) { writer.addByte(byte1); }
		if (int1 != null) { writer.addPackedInt(int1); }
		if (int2 != null) { writer.addPackedInt(int2); }
		if (int3 != null) { writer.addPackedInt(int3); }
		if (float1 != null) { writer.addFloat(float1); }
	}

	@Override public MocapAction.Result execute(MocapActionContext ctx)
	{
		class_1297 entity = ctx.getEntity();

		if (entity instanceof class_1296 ageableMob)
		{
			if (ageableMob.method_5618() < 0) { ageableMob.method_5614(0); } // prevent mob from growing up and resetting IS_BABY flag
			EntityData.AGEABLE_MOB_IS_BABY.set(entity, flag2);
		}

		if (entity instanceof class_1496)
		{
			if (byte1 == null) { return Result.ERROR; }
			EntityData.ABSTRACT_HORSE_FLAGS.set(entity, byte1);

			try
			{
				class_1799 itemStack = new class_1799((byte1 & 0x04) != 0 ? class_1802.field_8175 : class_1802.field_8162);
				((AbstractHorseFields)entity).getInventory().method_5447(0, itemStack);
			}
			catch (Exception ignore) {}

			if (entity instanceof class_1498) { ((HorseFields)entity).callSetTypeVariant(int1 != null ? int1 : 0); }
			else if (entity instanceof class_1492 chestedHorse) { chestedHorse.method_6704(flag1); }
			else if (entity instanceof class_7689 camel) { camel.method_45362(flag1); }

			if (entity instanceof class_1501) { ((LlamaFields)entity).callSetVariant(class_1501.class_7993.method_47876(int1 != null ? int1 : 0)); }
		}
		else if (entity instanceof class_1690 boat)
		{
			if (int1 == null || int2 == null || int3 == null || float1 == null) { return Result.ERROR; }
			boat.method_64490(flag1, flag2);
			boat.method_54299(int1);
			boat.method_54300(int2);
			((BoatFields)entity).callSetBubbleTime(int3);
			boat.method_54297(float1);
		}
		else if (entity instanceof class_1688 minecart)
		{
			if (int1 == null || int2 == null || float1 == null) { return Result.ERROR; }
			minecart.method_54299(int1);
			minecart.method_54300(int2);
			minecart.method_54297(float1);
		}
		else if (entity instanceof class_1665)
		{
			((AbstractArrowFields)entity).callSetInGround(flag1);
		}

		return MocapAction.Result.OK;
	}
}
