package net.mt1006.mocap.mocap.actions;

import net.minecraft.class_1297;
import net.minecraft.class_1934;
import net.minecraft.class_3222;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapActionContext;
import net.mt1006.mocap.api.v1.extension.actions.MocapStateAction;
import net.mt1006.mocap.mocap.settings.Settings;

public class SetSpectator implements MocapStateAction
{
	private final boolean isSpectator;

	public SetSpectator(class_1297 entity)
	{
		isSpectator = entity instanceof class_3222 && (((class_3222)entity).field_13974.method_14257() == class_1934.field_9219);
	}

	public SetSpectator(Reader reader)
	{
		isSpectator = reader.readBoolean();
	}

	@Override public boolean differs(MocapStateAction previousAction)
	{
		return isSpectator != ((SetSpectator)previousAction).isSpectator;
	}

	@Override public boolean shouldBeInitialized()
	{
		return isSpectator;
	}

	@Override public void write(Writer writer, MocapRecordingData data)
	{
		writer.addBoolean(isSpectator);
	}

	@Override public Result execute(MocapActionContext ctx)
	{
		if (!(ctx.getEntity() instanceof class_3222)) { return Result.IGNORED; }
		((class_3222)ctx.getEntity()).method_7336(isSpectator
				? class_1934.field_9219
				: (Settings.USE_CREATIVE_GAME_MODE.val ? class_1934.field_9220 : class_1934.field_9215));
		return Result.OK;
	}
}
