package net.mt1006.mocap.mocap.actions;

import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapActionContext;
import net.mt1006.mocap.api.v1.extension.actions.MocapStateAction;
import org.jetbrains.annotations.Nullable;

public class Swing implements MocapStateAction
{
	private final boolean swinging;
	private final int swingingTime;
	private final class_1268 hand;

	public static @Nullable Swing fromEntity(class_1297 entity)
	{
		return (entity instanceof class_1309 livingEntity) ? new Swing(livingEntity) : null;
	}

	private Swing(class_1309 entity)
	{
		swinging = entity.field_6252;
		swingingTime = entity.field_6279;
		hand = entity.field_6266;
	}

	public Swing(Reader reader)
	{
		swinging = true;
		swingingTime = 0;
		hand = reader.readBoolean() ? class_1268.field_5810 : class_1268.field_5808;
	}

	@Override public boolean differs(MocapStateAction previousAction)
	{
		Swing previousSwing = (Swing)previousAction;
		return swinging && (previousSwing == null || !previousSwing.swinging || previousSwing.swingingTime > swingingTime);
	}

	@Override public boolean shouldBeInitialized()
	{
		return false;
	}

	@Override public void write(Writer writer, MocapRecordingData data)
	{
		writer.addBoolean(hand == class_1268.field_5810);
	}

	@Override public Result execute(MocapActionContext ctx)
	{
		if (!(ctx.getEntity() instanceof class_1309)) { return Result.IGNORED; }
		((class_1309)ctx.getEntity()).method_6104(hand);
		return Result.OK;
	}
}
