package net.mt1006.mocap.mocap.actions.deprecated;

import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1492;
import net.minecraft.class_1496;
import net.minecraft.class_1498;
import net.minecraft.class_1501;
import net.minecraft.class_1688;
import net.minecraft.class_1690;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_7689;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapActionContext;
import net.mt1006.mocap.mixin.fields.AbstractHorseFields;
import net.mt1006.mocap.mixin.fields.BoatFields;
import net.mt1006.mocap.mixin.fields.HorseFields;
import net.mt1006.mocap.mixin.fields.LlamaFields;
import net.mt1006.mocap.utils.EntityData;

public class SetVehicleData implements MocapAction
{
	private final boolean used;
	private final byte flags;      // AbstractHorse
	private final boolean flag1;   // Camel - is dashing; AbstractChestedHorse - has chest; Boat - is left paddle turning
	private final boolean flag2;   // AgeableMob - is baby; Boat - is right paddle turning
	private final int int1;        // Horse/Llama - variant; Boat - time since last hit; AbstractMinecart - shaking power
	private final int int2;        // Boat - hit direction; AbstractMinecart - shaking direction
	private final int int3;        // Boat - splash timer; AbstractMinecart - shaking multiplier
	private final float float1;    // Boat - damage taken

	public SetVehicleData(Reader reader)
	{
		used = reader.readBoolean();
		flags = used ? reader.readByte() : 0;
		flag1 = used && reader.readBoolean();
		flag2 = used && reader.readBoolean();
		int1 = used ? reader.readInt() : 0;
		int2 = used ? reader.readInt() : 0;
		int3 = used ? reader.readInt() : 0;
		float1 = used ? reader.readFloat() : 0;
	}

	@Override public void write(Writer writer, MocapRecordingData data)
	{
		//TODO: [CONVERTER] replace with exception
		writer.addBoolean(used);
		if (used)
		{
			writer.addByte(flags);
			writer.addBoolean(flag1);
			writer.addBoolean(flag2);
			writer.addInt(int1);
			writer.addInt(int2);
			writer.addInt(int3);
			writer.addFloat(float1);
		}
	}

	@Override public Result execute(MocapActionContext ctx)
	{
		if (!used) { return Result.IGNORED; }
		class_1297 entity = ctx.getEntity();

		if (entity instanceof class_1296 ageableMob)
		{
			ageableMob.method_5614(flag2 ? -1 : 0);
		}

		if (entity instanceof class_1496)
		{
			EntityData.ABSTRACT_HORSE_FLAGS.set(entity, flags);

			try
			{
				class_1799 itemStack = new class_1799((flags & 0x04) != 0 ? class_1802.field_8175 : class_1802.field_8162);
				((AbstractHorseFields)entity).getInventory().method_5447(0, itemStack);
			}
			catch (Exception ignore) {}

			if (entity instanceof class_1498) { ((HorseFields)entity).callSetTypeVariant(int1); }
			else if (entity instanceof class_1492 chestedHorse) { chestedHorse.method_6704(flag1); }
			else if (entity instanceof class_7689 camel) { camel.method_45362(flag1); }

			if (entity instanceof class_1501) { ((LlamaFields)entity).callSetVariant(class_1501.class_7993.method_47876(int1)); }
		}
		else if (entity instanceof class_1690 boat)
		{
			boat.method_64490(flag1, flag2);
			boat.method_54299(int1);
			boat.method_54300(int2);
			((BoatFields)entity).callSetBubbleTime(int3);
			boat.method_54297(float1);
		}
		else if (entity instanceof class_1688 minecart)
		{
			minecart.method_54299(int1);
			minecart.method_54300(int2);
			minecart.method_54297(float1);
		}

		return Result.OK;
	}
}
