package net.mt1006.mocap.mocap.files;

import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.mt1006.mocap.MocapMod;
import net.mt1006.mocap.api.impl.extenstion.Extensions;
import net.mt1006.mocap.api.v1.controller.config.MocapPlaybackConfig;
import net.mt1006.mocap.api.v1.extension.MocapExtension;
import net.mt1006.mocap.api.v1.extension.MocapPositionTransformer;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapBlockAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapStateAction;
import net.mt1006.mocap.api.v1.extension.actions.MocapTickAction;
import net.mt1006.mocap.api.v1.io.CommandOutput;
import net.mt1006.mocap.command.converter.AlphaConverter;
import net.mt1006.mocap.mocap.actions.ActionType;
import net.mt1006.mocap.mocap.actions.BlockStateData;
import net.mt1006.mocap.mocap.playing.playable.RecordingFile;
import net.mt1006.mocap.mocap.playing.playback.ActionContext;
import net.mt1006.mocap.mocap.playing.playback.PreExecuteContext;
import net.mt1006.mocap.mocap.recording.PositionTracker;
import net.mt1006.mocap.utils.EntityData;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.*;

public class RecordingData implements MocapRecordingData
{
	public static final RecordingData DUMMY = new RecordingData();

	private static final byte FLAGS1_ENDS_WITH_DEATH =         0b00000001;
	private static final byte FLAGS1_PACKED_SIZE_STRINGS =     0b00000010;
	private static final byte FLAGS1_HAS_ID_MAPS =             0b00000100;
	private static final byte FLAGS1_DIMENSION_SPECIFIED =     0b00001000;
	private static final byte FLAGS1_PLAYER_NAME_SPECIFIED =   0b00010000;
	private static final byte FLAGS1_HAS_EXTENSIONS =          0b00100000;
	private static final byte FLAGS1_EXPERIMENTAL_SUBVERSION = 0b01000000;
	private static final byte FLAGS1_HAS_FLAGS2 =        (byte)0b10000000;

	public long fileSize = 0;
	public byte version = 0;
	public boolean experimentalVersion = false;
	public class_243 startPos = class_243.field_1353;
	public final float[] startRot = new float[2];
	public boolean endsWithDeath = false; // deprecated
	private boolean usesIdMaps = true;
	private final ItemIdMap itemIdMap = new ItemIdMap(this);
	private final BlockStateIdMap blockStateIdMap = new BlockStateIdMap(this);
	public @Nullable class_2960 dimensionId = null; //TODO: use it
	public @Nullable String playerName = null;
	private final SortedMap<Integer, MocapExtension> extensionById = new TreeMap<>();
	private final Map<MocapExtension, Byte> extensionToId = new HashMap<>();
	private final Map<MocapExtension, ExtensionHeader> extensionHeaders = new HashMap<>();
	public byte experimentalSubversion = 0;
	public final List<MocapAction> actions = new ArrayList<>();
	public final List<MocapBlockAction> blockActions = new ArrayList<>();
	public long tickCount = 0;

	public static RecordingData forWriting()
	{
		RecordingData data = new RecordingData();
		data.setCurrentVersion();
		return data;
	}

	public void save(BufferedOutputStream stream) throws IOException
	{
		if (version != RecordingFiles.VERSION) { throw new RuntimeException("Trying to save recording with read-only version."); }
		actions.forEach((a) -> ActionType.prepareToWriteAction(this, a));

		RecordingFiles.Writer writer = new RecordingFiles.Writer();

		writer.addByte((byte)(experimentalVersion ? (-version) : version));
		saveHeader(writer);
		actions.forEach((a) -> ActionType.writeAction(writer, this, a));

		stream.write(writer.toByteArray());
	}

	//TODO: [CONVERTER] remove last arg
	public boolean load(CommandOutput out, @Nullable RecordingFile file, boolean useConverter)
	{
		if (file == null) { return false; }
		byte[] data = Files.loadFile(file.getFile());
		return data != null && load(out, new RecordingFiles.FileReader(data, true), useConverter);
	}

	//TODO: [CONVERTER] remove last arg
	private boolean load(CommandOutput out, RecordingFiles.FileReader reader, boolean useConverter)
	{
		fileSize = reader.getSize();

		byte versionByte = reader.readByte();
		version = (byte)Math.abs(versionByte);
		experimentalVersion = (versionByte < 0);

		if (version > RecordingFiles.VERSION)
		{
			out.sendFailure("playback.start.error.load_header");
			return false;
		}

		if (!loadHeader(out, reader, version == 1 || version == 2, useConverter)) { return false; } //TODO: test old recordings

		//TODO: [CONVERTER] remove
		AlphaConverter converter = (experimentalVersion && version == 5 && experimentalSubversion == 0 && useConverter)
				? new AlphaConverter(startPos)
				: null;

		while (reader.canRead())
		{
			MocapAction action = ActionType.readAction(reader, this, converter, null);
			if (action == null) { return false; }

			actions.add(action);
			if (action instanceof MocapBlockAction) { blockActions.add((MocapBlockAction)action); }
			else if (action instanceof MocapTickAction tickAction) { tickCount += tickAction.getTickCount(); }
		}
		return true;
	}

	private void saveHeader(RecordingFiles.Writer writer)
	{
		boolean hasIdMaps = usesIdMaps && (itemIdMap.size() != 0 || blockStateIdMap.size() != 0);

		writer.addVec3(startPos);
		writer.addFloat(startRot[0]);
		writer.addFloat(startRot[1]);

		byte flags1 = 0;
		flags1 |= endsWithDeath ? FLAGS1_ENDS_WITH_DEATH : 0;
		flags1 |= FLAGS1_PACKED_SIZE_STRINGS;
		flags1 |= hasIdMaps ? FLAGS1_HAS_ID_MAPS : 0;
		flags1 |= dimensionId != null ? FLAGS1_DIMENSION_SPECIFIED : 0;
		flags1 |= playerName != null ? FLAGS1_PLAYER_NAME_SPECIFIED : 0;
		flags1 |= !extensionById.isEmpty() ? FLAGS1_HAS_EXTENSIONS : 0;
		flags1 |= experimentalSubversion != 0 ? FLAGS1_EXPERIMENTAL_SUBVERSION : 0;
		writer.addByte(flags1);

		if (hasIdMaps)
		{
			itemIdMap.save(writer);
			blockStateIdMap.save(writer);
		}

		if (dimensionId != null) { writer.addString(dimensionId.toString()); }
		if (playerName != null) { writer.addString(playerName); }
		if (!extensionById.isEmpty()) { saveExtensionHeaders(writer); }
		if (experimentalSubversion != 0) { writer.addByte(experimentalSubversion); }
	}

	private void saveExtensionHeaders(RecordingFiles.Writer writer)
	{
		writer.addByte((byte)extensionById.size());

		int expectedId = 0;
		for (Map.Entry<Integer, MocapExtension> entry : extensionById.entrySet())
		{
			if (entry.getKey() != expectedId) { throw new RuntimeException("Extensions in wrong order! Trying to save loaded recording?"); }
			expectedId++;

			MocapExtension extension = entry.getValue();
			writer.addString(extension.getId());
			writer.addShort(extension.getVersion());
			writer.addByte(extension.isRequired() ? Extensions.FLAGS_IS_REQUIRED : 0);

			RecordingFiles.Writer headerWriter = new RecordingFiles.Writer();
			extensionHeaders.get(extension).save(headerWriter);
			writer.addPackedInt(headerWriter.getSize());
			headerWriter.copyToWriter(writer);
		}
	}

	//TODO: [CONVERTER] remove last arg
	private boolean loadHeader(CommandOutput out, RecordingFiles.FileReader reader, boolean legacyHeader, boolean useConverter)
	{
		startPos = reader.readVec3();
		startRot[0] = reader.readFloat();
		startRot[1] = reader.readFloat();
		if (legacyHeader) { return true; }

		byte flags1 = reader.readByte();
		endsWithDeath = (flags1 & FLAGS1_ENDS_WITH_DEATH) != 0;
		reader.setStringMode((flags1 & FLAGS1_PACKED_SIZE_STRINGS) == 0);
		usesIdMaps = (flags1 & FLAGS1_HAS_ID_MAPS) != 0;
		boolean startDimensionSpecified = (flags1 & FLAGS1_DIMENSION_SPECIFIED) != 0;
		boolean playerNameSpecified = (flags1 & FLAGS1_PLAYER_NAME_SPECIFIED) != 0;
		boolean hasExtensions = (flags1 & FLAGS1_HAS_EXTENSIONS) != 0;
		boolean hasExperimentalSubversion = (flags1 & FLAGS1_EXPERIMENTAL_SUBVERSION) != 0;

		if (experimentalVersion && version == 5 && !hasExperimentalSubversion)
		{
			// recorded between 1.4-alpha-1 and 1.4-alpha-8
			// not compatible with current recording file format

			//TODO: [CONVERTER] do not remove! maybe move it somewhere else and replace conversion mode with failure message
			if (useConverter)
			{
				//TODO: [CONVERTER] this should be removed
				reader.convertStrings = true;
			}
			else
			{
				out.sendFailure("failure.not_supported_experimental_format");

				//TODO: [CONVERTER] remove suggestions (including language keys)
				out.sendFailure("failure.not_supported_experimental_format.suggest_converter.1");
				out.sendFailure("failure.not_supported_experimental_format.suggest_converter.2");
				return false;
			}
		}
		else if (useConverter)
		{
			return out.sendFailure("misc.converter.not_convertible");
		}

		if (usesIdMaps)
		{
			itemIdMap.load(reader);
			blockStateIdMap.load(reader);
		}

		if (startDimensionSpecified) { dimensionId = class_2960.method_60654(reader.readString()); }
		if (playerNameSpecified) { playerName = reader.readString(); }
		if (hasExtensions && !loadExtensionHeaders(out, reader)) { return false; }
		if (hasExperimentalSubversion) { experimentalSubversion = reader.readByte(); }
		return true;
	}

	private boolean loadExtensionHeaders(CommandOutput out, RecordingFiles.FileReader reader)
	{
		int extensionCount = Byte.toUnsignedInt(reader.readByte());
		for (int i = 0; i < extensionCount; i++)
		{
			//TODO: add extension version to error str
			String extensionId = reader.readString();
			short minVersion = reader.readShort();
			boolean isRequiredFlag = (reader.readByte() & Extensions.FLAGS_IS_REQUIRED) != 0;
			int headerSize = reader.readPackedInt();

			MocapExtension extension = Extensions.getExtension(extensionId, minVersion);
			if (extension == null)
			{
				if (Extensions.isRequired(isRequiredFlag))
				{
					out.sendFailure("playback.start.error.extension.not_present", extensionId);
					return false;
				}
				else
				{
					reader.shift(headerSize);
					continue;
				}
			}

			ExtensionHeader extensionHeader = extension.createHeader();
			if (!extensionHeader.load(reader))
			{
				out.sendFailure("playback.start.error.extension.load_header", extensionId);
				return false;
			}

			addExtension(i, extension, extensionHeader);
		}
		return true;
	}

	private void addExtension(int id, MocapExtension extension, ExtensionHeader extensionHeader)
	{
		extensionById.put(id, extension);
		extensionToId.put(extension, (byte)id);
		extensionHeaders.put(extension, extensionHeader);
	}

	public void initAndAddExtension(MocapExtension extension)
	{
		addExtension(extensionById.size(), extension, extension.createHeader());
	}

	public void setCurrentVersion()
	{
		version = RecordingFiles.VERSION;
		experimentalVersion = MocapMod.EXPERIMENTAL;
		experimentalSubversion = MocapMod.EXPERIMENTAL ? MocapMod.RECORDING_FORMAT_EXP_SUBVERSION : 0;
	}

	public void initEntityPosition(class_1297 entity, MocapPositionTransformer transformer, boolean teleportFarAway)
	{
		class_243 pos = teleportFarAway ? PositionTracker.FAR_AWAY : transformer.transformPos(startPos);
		float rotY = transformer.transformRotation(startRot[0]);
		entity.method_60949(pos, rotY, startRot[1]);
		entity.method_5847(rotY);
	}

	public void preExecute(PreExecuteContext ctx)
	{
		if (ctx.getConfig().getBlockInitialization())
		{
			for (int i = blockActions.size() - 1; i >= 0; i--)
			{
				blockActions.get(i).initBlocks(ctx);
			}
		}
	}

	public MocapAction.Result executeAction(ActionContext ctx, MocapPlaybackConfig config, boolean initialAction, int pos)
	{
		if (pos >= actions.size()) { return MocapAction.Result.END; }

		try
		{
			MocapAction nextAction = actions.get(pos);
			if (!config.getBlockActionsPlayback() && nextAction instanceof BlockStateData) { return MocapAction.Result.OK; }
			if (initialAction)
			{
				if (nextAction instanceof MocapTickAction tickAction && tickAction.endsTick()) { return MocapAction.Result.NEXT_TICK; }
				if ((!(nextAction instanceof MocapStateAction stateAction) || !stateAction.shouldBeInitialized())) { return MocapAction.Result.IGNORED; }
			}

			return nextAction.execute(ctx);
		}
		catch (Exception e)
		{
			Utils.exception(e, "Exception occurred while executing action!");
			return MocapAction.Result.ERROR;
		}
	}

	public void firstExecute(class_1297 entity)
	{
		if (entity instanceof class_1657)
		{
			//TODO: recording skin parts
			EntityData.PLAYER_SKIN_PARTS.set(entity, (byte)0b01111111);
		}
	}

	@Override public class_243 getStartPos()
	{
		return startPos;
	}

	@Override public class_1792 itemFromId(int id)
	{
		return itemIdMap.getObject(id);
	}

	@Override public int provideItemId(class_1792 item)
	{
		return itemIdMap.provideMappedId(item);
	}

	@Override public class_2680 blockStateFromId(int id)
	{
		return blockStateIdMap.getMappedObject(id);
	}

	@Override public int provideBlockStateId(class_2680 blockState)
	{
		return blockStateIdMap.provideMappedId(blockState);
	}

	@Override public @Nullable MocapExtension getExtension(byte idFromRecording)
	{
		return extensionById.get(Byte.toUnsignedInt(idFromRecording));
	}

	@Override public @Nullable Byte getExtensionId(MocapExtension extension)
	{
		return extensionToId.get(extension);
	}

	public static abstract class RefIdMap<T>
	{
		protected final RecordingData parent;
		protected final Reference2IntMap<T> refToId = new Reference2IntOpenHashMap<>();
		protected final List<T> idToRef = new ArrayList<>();

		public RefIdMap(RecordingData parent)
		{
			this.parent = parent;
			init();
		}

		public int size()
		{
			return idToRef.size() - 1;
		}

		protected int provideMappedId(T ref)
		{
			int id = refToId.getOrDefault(ref, -1);
			return id != -1 ? id : put(ref);
		}

		protected T getMappedObject(int id)
		{
			return idToRef.get(id);
		}

		protected int put(T ref)
		{
			int pos = idToRef.size();
			idToRef.add(ref);
			refToId.put(ref, pos);
			return pos;
		}

		protected String resLocToStr(class_2960 resLoc)
		{
			//TODO: test with mods
			return resLoc.method_12836().equals(class_2960.field_33381)
					? resLoc.method_12832()
					: resLoc.toString();
		}

		protected abstract void init();
		public abstract int provideId(T ref);
		public abstract T getObject(int id);
		protected abstract void save(MocapAction.Writer writer);
		protected abstract void load(MocapAction.Reader reader);
	}

	public static class ItemIdMap extends RefIdMap<class_1792>
	{
		public ItemIdMap(RecordingData parent) { super(parent); }

		@Override protected void init() { put(class_1802.field_8162); }

		@Override public int provideId(class_1792 item)
		{
			return parent.usesIdMaps ? provideMappedId(item) : class_1792.method_7880(item);
		}

		@Override public class_1792 getObject(int id)
		{
			return parent.usesIdMaps ? getMappedObject(id) : class_1792.method_7875(id);
		}

		@Override protected void save(MocapAction.Writer writer)
		{
			writer.addInt(size());
			idToRef.subList(1, idToRef.size()).forEach((item) -> writer.addString(resLocToStr(class_7923.field_41178.method_10221(item))));
		}

		@Override protected void load(MocapAction.Reader reader)
		{
			int size = reader.readInt();

			for (int i = 1; i <= size; i++)
			{
				Optional<class_6880.class_6883<class_1792>> itemHolder = class_7923.field_41178.method_10223(class_2960.method_60654(reader.readString()));
				class_1792 item = itemHolder.get().comp_349();
				refToId.put(item, i);
				idToRef.add(item);
			}
		}
	}

	public static class BlockStateIdMap extends RefIdMap<class_2680>
	{
		public BlockStateIdMap(RecordingData parent) { super(parent); }

		@Override protected void init() { put(class_2246.field_10124.method_9564()); }

		@Override public int provideId(class_2680 blockState)
		{
			return parent.usesIdMaps ? provideMappedId(blockState) : class_2248.method_9507(blockState);
		}

		@Override public class_2680 getObject(int id)
		{
			return parent.usesIdMaps ? getMappedObject(id) : class_2248.method_9531(id);
		}

		@Override protected void save(MocapAction.Writer writer)
		{
			writer.addInt(size());

			for (class_2680 blockState : idToRef.subList(1, idToRef.size()))
			{
				Collection<class_2769<?>> properties = blockState.method_28501();
				if (properties.size() > Short.MAX_VALUE)
				{
					MocapMod.LOGGER.warn("BlockState properties count limit reached ({})!", properties.size());
					properties = List.of();
				}

				writer.addString(resLocToStr(class_7923.field_41175.method_10221(blockState.method_26204())));
				writer.addShort((short)properties.size());

				for (class_2769<?> property : properties)
				{
					writer.addString(property.method_11899());
					writer.addString(propertyValueToStr(blockState, property));
				}
			}
		}

		@Override protected void load(MocapAction.Reader reader)
		{
			int size = reader.readInt();

			for (int i = 1; i <= size; i++)
			{
				Optional<class_6880.class_6883<class_2248>> blockHolder = class_7923.field_41175.method_10223(class_2960.method_60654(reader.readString()));
				class_2248 block = blockHolder.get().comp_349();
				class_2689<class_2248, class_2680> stateDefinition = block.method_9595();
				class_2680 blockState = block.method_9564();

				short propertyCount = reader.readShort();
				for (int j = 0; j < propertyCount; j++)
				{
					class_2769<?> property = stateDefinition.method_11663(reader.readString());
					blockState = updateBlockState(blockState, property, reader.readString());
				}

				refToId.put(blockState, i);
				idToRef.add(blockState);
			}
		}

		private static <T extends Comparable<T>> String propertyValueToStr(class_2680 blockState, class_2769<T> property)
		{
			return property.method_11901(blockState.method_11654(property));
		}

		private static <T extends Comparable<T>> class_2680 updateBlockState(class_2680 blockState, @Nullable class_2769<T> property, String str)
		{
			if (property == null) { return blockState; }
			Optional<T> value = property.method_11900(str);
			return value.map((val) -> blockState.method_11657(property, val)).orElse(blockState);
		}
	}
}
