package net.mt1006.mocap.mocap.playing.modifiers;

import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1542;
import net.minecraft.class_1676;
import net.minecraft.class_1688;
import net.minecraft.class_1690;
import net.minecraft.class_1695;
import net.minecraft.class_2960;
import net.minecraft.class_6026;
import net.minecraft.class_7923;
import net.mt1006.mocap.api.v1.io.CommandOutput;
import net.mt1006.mocap.mocap.files.Files;
import org.jetbrains.annotations.Nullable;

import java.util.*;

public class EntityFilterInstance
{
	private static final String EMPTY_GROUP = "none";
	public final String filterStr;
	private final List<Element> elements;

	private EntityFilterInstance(String str) throws FilterParserException
	{
		this.filterStr = str;
		this.elements = Collections.unmodifiableList(parse(str));
	}

	private static List<Element> parse(String str) throws FilterParserException
	{
		List<Element> elements = new ArrayList<>();
		if (str.isEmpty()) { return elements; }
		String[] parts = str.split(";");

		for (String part : parts)
		{
			if (part.isBlank()) { throw new FilterParserException(); }

			boolean exclude = (part.charAt(0) == '-');
			if (exclude && part.length() == 1) { throw new FilterParserException(); }

			char firstChar = part.charAt(exclude ? 1 : 0);

			if (firstChar == '@')
			{
				String groupName = part.substring(exclude ? 2 : 1);
				if (groupName.equals(EMPTY_GROUP)) { continue; } // "@none" is just ignored
				if (!Files.checkIfProperName(CommandOutput.DUMMY, groupName)) { throw new FilterParserException(); }

				GroupElement groupElement = Group.fromString(exclude, groupName);
				if (groupElement == null) { throw new FilterParserException(); }
				elements.add(groupElement);
			}
			else if (firstChar == '$')
			{
				String tagName = part.substring(exclude ? 2 : 1);
				elements.add(new TagElement(exclude, tagName));
			}
			else
			{
				String name = exclude ? part.substring(1) : part;

				if (name.equals("*"))
				{
					elements.add(exclude ? AllEntitiesElement.EXCLUDE_ALL : AllEntitiesElement.INCLUDE_ALL);
					continue;
				}

				if (name.endsWith(":*"))
				{
					if (name.length() == 2) { throw new FilterParserException(); }
					String namespace = name.substring(0, name.length() - 2);
					if (!class_2960.method_20209(namespace)) { throw new FilterParserException(); }

					elements.add(new AllEntitiesElement(exclude, namespace));
					continue;
				}

				class_2960 resLoc = parseToResLoc(name);
				Element lastElement = elements.isEmpty() ? null : elements.get(elements.size() - 1);

				boolean reuseEntitySet = (lastElement instanceof EntitySetElement && lastElement.exclude == exclude);
				EntitySetElement entitySetElement = reuseEntitySet ? (EntitySetElement)lastElement : new EntitySetElement(exclude);
				entitySetElement.add(resLoc);
				if (!reuseEntitySet) { elements.add(entitySetElement); }
			}
		}
		return elements;
	}

	public static @Nullable EntityFilterInstance create(String str)
	{
		try { return new EntityFilterInstance(str); }
		catch (FilterParserException e) { return null; }
	}

	public static boolean test(String str)
	{
		try
		{
			parse(str);
			return true;
		}
		catch (FilterParserException e) { return false; }
	}

	public boolean isAllowed(class_1297 entity)
	{
		boolean allowed = false;
		for (Element element : elements)
		{
			switch (element.isAllowed(entity))
			{
				case ALLOW -> allowed = true;
				case DENY -> allowed = false;
				case IGNORE -> {}
			}
		}
		return allowed;
	}

	public boolean isEmpty()
	{
		return elements.isEmpty();
	}

	private static class_2960 parseToResLoc(String str) throws FilterParserException
	{
		class_2960 resLoc = class_2960.method_12829(str);
		if (resLoc == null) { throw new FilterParserException(); }
		return resLoc;
	}

	private static abstract class Element
	{
		private final boolean exclude;

		protected Element(boolean exclude)
		{
			this.exclude = exclude;
		}

		public FilterElementResults isAllowed(class_1297 entity)
		{
			return applies(entity)
					? (exclude ? FilterElementResults.DENY : FilterElementResults.ALLOW)
					: FilterElementResults.IGNORE;
		}

		protected abstract boolean applies(class_1297 entity);
	}

	private static class GroupElement extends Element
	{
		public final String name;
		private final List<Class<?>> parents;

		public GroupElement(boolean exclude, String name, List<Class<?>> parents)
		{
			super(exclude);
			this.name = name;
			this.parents = parents;
		}

		protected boolean applies(class_1297 entity)
		{
			for (Class<?> parent : parents)
			{
				if (parent.isInstance(entity)) { return true; }
			}
			return false;
		}
	}

	private static class TagElement extends Element
	{
		public final String tag;

		public TagElement(boolean exclude, String tag)
		{
			super(exclude);
			this.tag = tag;
		}

		@Override protected boolean applies(class_1297 entity)
		{
			return entity.method_5752().contains(tag);
		}
	}

	private static class EntitySetElement extends Element
	{
		public final Set<class_1299<?>> set = new HashSet<>(); //TODO: make it immutable

		public EntitySetElement(boolean exclude)
		{
			super(exclude);
		}

		public void add(class_2960 resLoc)
		{
			Optional<class_1299<?>> entityType = class_7923.field_41177.method_17966(resLoc);
			entityType.ifPresent(set::add);
		}

		@Override protected boolean applies(class_1297 entity)
		{
			return set.contains(entity.method_5864());
		}
	}

	private static class AllEntitiesElement extends Element
	{
		public final static AllEntitiesElement INCLUDE_ALL = new AllEntitiesElement(false, null);
		public final static AllEntitiesElement EXCLUDE_ALL = new AllEntitiesElement(false, null);
		private final @Nullable String fromNamespace;

		public AllEntitiesElement(boolean exclude, @Nullable String fromNamespace)
		{
			super(exclude);
			this.fromNamespace = fromNamespace;
		}

		@Override protected boolean applies(class_1297 entity)
		{
			if (fromNamespace == null) { return true; }
			return class_7923.field_41177.method_10221(entity.method_5864()).method_12836().equals(fromNamespace);
		}
	}

	public static class FilterParserException extends Exception {}

	private enum FilterElementResults
	{
		ALLOW, DENY, IGNORE
	}

	private enum Group
	{
		VEHICLES(List.of(class_6026.class, class_1695.class, class_1690.class)),
		PROJECTILES(List.of(class_1676.class)),
		ITEMS(List.of(class_1542.class)),
		MOBS(List.of(class_1308.class)),
		MINECARTS(List.of(class_1688.class));

		public final String name;
		public final GroupElement include, exclude;

		Group(List<Class<?>> parent)
		{
			this.name = name().toLowerCase();
			this.include = new GroupElement(false, name, parent);
			this.exclude = new GroupElement(true, name, parent);
		}

		public static @Nullable GroupElement fromString(boolean exclude, String str)
		{
			try
			{
				Group group = valueOf(str.toUpperCase());
				return exclude ? group.exclude : group.include;
			}
			catch (IllegalArgumentException e) { return null; }
		}
	}
}
