package net.mt1006.mocap.mocap.playing.modifiers;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3730;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8942;
import net.mt1006.mocap.api.v1.modifiers.MocapPlayerAsEntity;
import net.mt1006.mocap.mocap.files.SceneFiles;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

public class PlayerAsEntity implements MocapPlayerAsEntity
{
	public static final PlayerAsEntity DISABLED = new PlayerAsEntity(null, null);
	private final @Nullable String entityId;
	public final @Nullable String entityNbt;
	private final @Nullable class_1299<?> entityType;
	private final @Nullable class_2487 compoundTag;

	public PlayerAsEntity(@Nullable String entityId, @Nullable String entityNbt)
	{
		this.entityId = entityId;
		this.entityNbt = entityNbt;
		this.entityType = prepareEntityType(entityId, entityNbt);
		this.compoundTag = prepareCompoundTag(entityId, entityNbt);
	}

	public static PlayerAsEntity fromObject(@Nullable SceneFiles.Reader reader)
	{
		return reader != null ? new PlayerAsEntity(reader.readString("id"), reader.readString("nbt")) : DISABLED;
	}

	@Override public boolean isEnabled()
	{
		return entityId != null;
	}

	@Override public @Nullable class_2960 getEntityId()
	{
		return entityId != null ? class_2960.method_12829(entityId) : null;
	}

	@Override public @Nullable class_1299<?> getEntityType()
	{
		class_2960 id = getEntityId();
		if (id == null || !class_7923.field_41177.method_10250(id)) { return null; }
		class_6880.class_6883<class_1299<?>> entityTypeRef = class_7923.field_41177.method_10223(id).orElse(null);
		return entityTypeRef != null ? entityTypeRef.comp_349() : null;
	}

	@Override public @Nullable String getRawEntityId()
	{
		return entityId;
	}

	@Override public @Nullable String getNbt()
	{
		return entityNbt;
	}

	@Override public @Nullable SceneFiles.Writer save()
	{
		if (!isEnabled()) { return null; }

		SceneFiles.Writer writer = new SceneFiles.Writer();
		writer.addString("id", entityId);
		writer.addString("nbt", entityNbt);

		return writer;
	}

	@Override public @Nullable class_1297 createEntity(class_1937 level)
	{
		if (entityType == null && compoundTag == null) { return null; }

		class_11368 nbt = class_11352.method_71417(class_8942.field_60348, level.method_30349(), compoundTag);
		return (compoundTag != null)
				? class_1299.method_5892(nbt, level, class_3730.field_16462).orElse(null)
				: entityType.method_5883(level, class_3730.field_16462);
	}

	private static @Nullable class_1299<?> prepareEntityType(@Nullable String entityId, @Nullable String entityNbt)
	{
		if (entityId == null || entityNbt != null) { return null; } // if entityNbt is present, it should be null

		class_2960 entityRes = class_2960.method_60654(entityId);
		class_6880.class_6883<class_1299<?>> entityTypeRef = class_7923.field_41177.method_10223(entityRes).orElse(null);
		return entityTypeRef != null ? entityTypeRef.comp_349() : null;
	}

	private static @Nullable class_2487 prepareCompoundTag(@Nullable String entityId, @Nullable String entityNbt)
	{
		if (entityId == null || entityNbt == null) { return null; }

		try
		{
			class_2487 nbt = Utils.nbtFromString(entityNbt);
			nbt.method_10582("id", entityId);
			return nbt;
		}
		catch (CommandSyntaxException e) { return null; }
	}
}
