package net.mt1006.mocap.mocap.playing.modifiers;

import net.minecraft.class_243;
import net.mt1006.mocap.mocap.files.SceneFiles;
import org.jetbrains.annotations.Nullable;

public class Rotation
{
	public static final Rotation ZERO = new Rotation(0.0);
	public final double deg;
	private final double sinDeg, cosDeg;
	public final boolean canRotateInt;
	public final net.minecraft.class_2470 blockRotation;

	private Rotation(double deg)
	{
		deg = clampRot(deg);
		this.deg = deg;
		this.sinDeg = calcSin(deg);
		this.cosDeg = calcCos(deg);
		this.canRotateInt = (deg == 0.0 || deg == 90.0 || deg == 180.0 || deg == -90.0);

		this.blockRotation = switch ((int)Math.round(deg / 90.0))
		{
			case -2, 2 -> net.minecraft.class_2470.field_11464;
			case -1 -> net.minecraft.class_2470.field_11465;
			case 1 -> net.minecraft.class_2470.field_11463;
			default -> net.minecraft.class_2470.field_11467;
		};
	}

	public static Rotation fromDouble(double val)
	{
		return val != 0.0 ? new Rotation(val) : ZERO;
	}

	public static double clampRot(double deg)
	{
		if (deg > -180.0 && deg <= 180.0) { return deg; }

		// keeping deg in range (-180.0;180.0]
		double val = (deg + 180.0) % 360.0;
		if (val <= 0.0) { val += 360.0; }
		return val - 180.0;
	}

	private static double calcSin(double deg)
	{
		if (deg == 0.0 || deg == 180.0) { return 0.0; }
		else if (deg == 90.0) { return 1.0; }
		else if (deg == -90.0) { return -1.0; }
		else { return Math.sin(Math.toRadians(deg)); }
	}

	private static double calcCos(double deg)
	{
		if (deg == 0.0) { return 1.0; }
		else if (deg == 90.0 || deg == -90.0) { return 0.0; }
		else if (deg == 180.0) { return -1.0; }
		else { return Math.cos(Math.toRadians(deg)); }
	}

	public @Nullable SceneFiles.Writer save()
	{
		if (deg == 0.0) { return null; }

		SceneFiles.Writer writer = new SceneFiles.Writer();
		writer.addDouble("deg", deg, 0.0);

		return writer;
	}

	public class_243 apply(class_243 point, class_243 center)
	{
		if (deg == 0.0) { return point; }

		double pointX = point.field_1352 - center.field_1352;
		double pointZ = point.field_1350 - center.field_1350;
		double finX = pointX * cosDeg - pointZ * sinDeg + center.field_1352;
		double finZ = pointZ * cosDeg + pointX * sinDeg + center.field_1350;
		return new class_243(finX, point.field_1351, finZ);
	}
}
