package net.mt1006.mocap.mocap.playing.playback;

import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_7828;
import net.mt1006.mocap.MocapMod;
import net.mt1006.mocap.api.v1.controller.config.MocapPlaybackConfig;
import net.mt1006.mocap.api.v1.extension.MocapPositionTransformer;
import net.mt1006.mocap.api.v1.extension.MocapRecordingData;
import net.mt1006.mocap.api.v1.extension.actions.MocapActionContext;
import net.mt1006.mocap.api.v1.modifiers.MocapModifiers;
import net.mt1006.mocap.events.PlayerConnectionEvent;
import net.mt1006.mocap.mocap.playing.PlaybackManager;
import net.mt1006.mocap.mocap.settings.Settings;
import net.mt1006.mocap.network.MocapPacketS2C;
import net.mt1006.mocap.utils.FakePlayer;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;

public class ActionContext implements MocapActionContext
{
	private final MocapRecordingData recordingData;
	private final class_3222 owner;
	private final class_3324 packetTargets;
	private final EntityData mainEntityData;
	private final Map<Integer, EntityData> entityDataMap = new HashMap<>();
	private final class_3218 level;
	private final MocapPlaybackConfig config;
	private final MocapModifiers modifiers;
	private final @Nullable FakePlayer ghostPlayer;
	private final PositionTransformer transformer;
	private boolean mainEntityRemoved = false;
	private @Nullable EntityData currentEntityData = null;
	private class_1297 entity;
	private class_243 position;
	private int repeatCounter = 0;

	public ActionContext(MocapRecordingData recordingData, class_3222 owner, class_3324 packetTargets, class_1297 entity,
						 MocapPlaybackConfig config, MocapModifiers modifiers, @Nullable FakePlayer ghostPlayer, PositionTransformer transformer)
	{
		if (!(entity.method_73183() instanceof class_3218))
		{
			throw new RuntimeException("Failed to get ServerLevel for ActionContext!");
		}

		this.recordingData = recordingData;
		this.owner = owner;
		this.packetTargets = packetTargets;
		this.mainEntityData = new EntityData(entity, recordingData.getStartPos());
		this.level = (class_3218) entity.method_73183();
		this.config = config;
		this.modifiers = modifiers;
		this.ghostPlayer = ghostPlayer;
		this.transformer = transformer;

		setMainContextEntity();
	}

	@Override public MocapRecordingData getRecordingData()
	{
		return recordingData;
	}

	@Override public class_1297 getEntity()
	{
		return entity;
	}

	@Override public class_3218 getLevel()
	{
		return level;
	}

	@Override public MocapPlaybackConfig getConfig()
	{
		return config;
	}

	@Override public MocapModifiers getModifiers()
	{
		return modifiers;
	}

	@Override public MocapPositionTransformer getTransformer()
	{
		return transformer;
	}

	@Override public class_1297 getMainEntity()
	{
		return mainEntityData.entity;
	}

	@Override public @Nullable class_3222 getDummyPlayer()
	{
		return ghostPlayer;
	}

	@Override public @Nullable class_3222 getRealOrDummyPlayer()
	{
		return (entity instanceof class_3222) ? (class_3222)entity : ghostPlayer;
	}

	@Override public @Nullable class_3222 getLivingEntityOrDummyPlayer()
	{
		return (entity instanceof class_3222) ? (class_3222)entity : ghostPlayer;
	}

	@Override public void setMainContextEntity()
	{
		setContextEntity(mainEntityData);
	}

	@Override public boolean setContextEntity(int id)
	{
		EntityData data = entityDataMap.get(id);
		if (data == null) { return false; }

		setContextEntity(data);
		return true;
	}

	private void setContextEntity(EntityData data)
	{
		if (currentEntityData != null) { currentEntityData.lastPosition = position; }
		currentEntityData = data;

		entity = data.entity;
		position = data.lastPosition;
	}

	@Override public void broadcast(class_2596<?> packet)
	{
		packetTargets.method_14581(packet);
	}

	@Override public void fluentMovement(Supplier<class_2596<?>> packetSupplier)
	{
		double fluentMovements = Settings.FLUENT_MOVEMENTS.val;
		if (fluentMovements == 0.0) { return; }
		class_2596<?> packet = packetSupplier.get();

		if (fluentMovements > 0.0)
		{
			class_243 pos = entity.method_73189();
			double maxDistSqr = fluentMovements * fluentMovements;

			for (class_3222 player : packetTargets.method_14571())
			{
				if (player.method_5707(pos) > maxDistSqr) { continue; }
				player.field_13987.method_14364(packet);
			}
		}
		else
		{
			packetTargets.method_14581(packet);
		}
	}

	public void removeAdditionalEntities()
	{
		entityDataMap.values().forEach((data) -> removeEntity(data.entity, level));
		entityDataMap.clear();
	}

	public void removeMainEntity()
	{
		if (mainEntityRemoved) { return; }
		mainEntityRemoved = true;

		FakePlayer playerToRemove;
		if (entity instanceof class_1657)
		{
			if (!(entity instanceof FakePlayer))
			{
				Utils.sendMessage(owner, "error.failed_to_remove_fake_player");
				MocapMod.LOGGER.error("Failed to remove fake player!");
				return;
			}
			playerToRemove = (FakePlayer)entity;
		}
		else
		{
			removeEntity(entity, level);
			if (ghostPlayer == null) { return; }
			playerToRemove = ghostPlayer;
		}

		UUID uuid = playerToRemove.method_5667();
		if (PlayerConnectionEvent.nocolPlayers.contains(uuid))
		{
			for (class_3222 player : PlayerConnectionEvent.players)
			{
				MocapPacketS2C.sendNocolPlayerRemove(player, uuid);
				PlayerConnectionEvent.removeNocolPlayer(uuid);
			}
		}
		if (playerToRemove != ghostPlayer) { broadcast(new class_7828(List.of(uuid))); }
		playerToRemove.method_5650(class_1297.class_5529.field_26998);
		playerToRemove.method_14236().method_12881();
	}

	@Override public class_243 getPosition()
	{
		return position;
	}

	@Override public void changePosition(class_243 newPos, float rotY, float rotX, boolean transformRot)
	{
		position = newPos;
		class_243 finPos = transformer.transformPos(position);
		float finRotY = transformRot ? transformer.transformRotation(rotY) : rotY;

		entity.method_60949(finPos, finRotY, rotX);
		if (ghostPlayer != null && entity == mainEntityData.entity) { ghostPlayer.method_60949(finPos, finRotY, rotX); }
	}

	@Override public void addEntity(int id, class_1297 entity, class_243 position)
	{
		entityDataMap.put(id, new EntityData(entity, position));
	}

	@Override public @Nullable EntityData getEntityData(int id)
	{
		return entityDataMap.get(id);
	}

	@Override public boolean hasEntity(int id)
	{
		return entityDataMap.containsKey(id);
	}

	@Override public void incrementRepeatCounter()
	{
		repeatCounter++;
	}

	@Override public boolean shouldStopRepeat(int iter)
	{
		if (repeatCounter == iter)
		{
			repeatCounter = 0;
			return true;
		}
		return false;
	}

	private void removeEntity(class_1297 entity, class_3218 level)
	{
		switch (config.getEntitiesAfterPlayback())
		{
			case REMOVE:
				entity.method_5650(class_1297.class_5529.field_26998);

			case KILL:
				entity.field_6008 = 0; // for sound effect
				if (entity instanceof FakePlayer) { ((FakePlayer)entity).fakeKill(); }
				else { entity.method_5768(level); }
				break;

			case LEFT_UNTOUCHED:
				break;

			case RELEASE_AS_NORMAL:
				entity.method_5875(false);
				entity.method_5684(false);
				entity.method_5738(PlaybackManager.MOCAP_ENTITY_TAG);
				if (entity instanceof class_1308) { ((class_1308)entity).method_5977(false); }
				break;

			default:
				throw new IllegalStateException("Unexpected value: " + config.getEntitiesAfterPlayback());
		}
	}
}
