package net.mt1006.mocap.mocap.playing.playback;

import net.minecraft.class_3222;
import net.mt1006.mocap.api.v1.controller.config.MocapPlaybackConfig;
import net.mt1006.mocap.api.v1.modifiers.MocapModifiers;
import net.mt1006.mocap.api.v1.modifiers.MocapTimeModifiers;
import net.mt1006.mocap.command.CommandsContext;
import net.mt1006.mocap.mocap.recording.RecordingContext;
import net.mt1006.mocap.mocap.recording.RecordingManager;
import org.jetbrains.annotations.Nullable;

public abstract class Playback
{
	//TODO: "playback.start.error.loop" and "playback.start.error.load" as failures, not errors

	protected final boolean isRoot;
	public final @Nullable class_3222 owner;
	public final MocapPlaybackConfig config;
	protected boolean finished = false, stopped = false;
	protected final MocapModifiers modifiers;
	protected int tickCounter = 0; //TODO: StartContext?
	protected int waitOnEnd = 0;

	protected Playback(boolean isRoot, @Nullable class_3222 owner, MocapPlaybackConfig config, MocapModifiers modifiers)
	{
		this.isRoot = isRoot;
		this.owner = owner;
		this.config = config;
		this.modifiers = modifiers;
	}

	public abstract void tick();

	public abstract void stop();

	protected abstract void loop();

	protected boolean isActive()
	{
		if (stopped) { return false; }

		MocapTimeModifiers timeModifiers = modifiers.getTimeModifiers();
		if (timeModifiers.getLoop()) { return !timeModifiers.getWaitForParentEnd(); }
		return !finished;
	}

	protected boolean shouldExecuteTick()
	{
		if (CommandsContext.haveSyncEnabled == 0 || owner == null) { return true; }

		CommandsContext commandsContext = CommandsContext.get(owner);
		if (!commandsContext.getSync()) { return true; }

		for (RecordingContext ctx : RecordingManager.bySourcePlayer(owner))
		{
			if (ctx.state == RecordingContext.State.RECORDING) { return true; }
		}
		return false;
	}

	protected boolean shouldSelfStop()
	{
		return (isRoot || !modifiers.getTimeModifiers().getWaitForParentEnd()) && finished;
	}

	protected void finishOrWaitOnEnd()
	{
		int timeWaitOnEnd = modifiers.getTimeModifiers().getWaitOnEnd().ticks;
		if (timeWaitOnEnd == 0) { finished = true; }
		else { waitOnEnd = timeWaitOnEnd; }
	}
}
