package net.mt1006.mocap.mocap.playing.playback;

import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.mt1006.mocap.api.v1.extension.MocapPositionTransformer;
import net.mt1006.mocap.api.v1.modifiers.MocapTransformations;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public class PositionTransformer implements MocapPositionTransformer
{
	private final MocapTransformations transformations;
	private final @Nullable PositionTransformer parent;
	private final @Nullable class_243 center;

	public PositionTransformer(MocapTransformations transformations, @Nullable PositionTransformer parent, @Nullable class_243 center)
	{
		this.transformations = transformations;
		this.parent = parent;
		this.center = center;
	}

	@Override public class_243 transformPos(class_243 point)
	{
		return transformPos(point, null);
	}

	private class_243 transformPos(class_243 point, @Nullable class_243 childCenter)
	{
		if (childCenter == null && center == null) { throw new RuntimeException("Both childCenter and center are null!"); }

		class_243 centerToUse = center != null ? center : childCenter;
		point = transformations.apply(point, centerToUse);

		return parent != null ? parent.transformPos(point, centerToUse) : point;
	}

	@Override public List<? extends class_2338> transformBlockPos(class_2338 blockPos, boolean allowScaled)
	{
		return transformBlockPos(List.of(blockPos), null, allowScaled);
	}

	private List<? extends class_2338> transformBlockPos(List<? extends class_2338> blockPos, @Nullable class_243 childCenter, boolean allowScaled)
	{
		if (childCenter == null && center == null) { throw new RuntimeException("Both childCenter and center are null!"); }

		class_243 centerToUse = center != null ? center : childCenter;
		List<? extends class_2338> list = transformations.applyToBlockPos(blockPos, centerToUse);
		if (list.size() > 1 && !allowScaled) { return List.of(); }

		return parent != null ? parent.transformBlockPos(list, centerToUse, allowScaled) : list;
	}

	@Override public class_2680 transformBlockState(class_2680 blockState)
	{
		blockState = transformations.applyToBlockState(blockState);
		return parent != null ? parent.transformBlockState(blockState) : blockState;
	}

	@Override public float transformRotation(float rot)
	{
		rot = (float)transformations.applyToRotation(rot);
		return parent != null ? parent.transformRotation(rot) : rot;
	}
}
