package net.mt1006.mocap.mocap.playing.playback;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.PropertyMap;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1934;
import net.minecraft.class_243;
import net.minecraft.class_2703;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.mt1006.mocap.MocapMod;
import net.mt1006.mocap.api.v1.controller.config.MocapDimensionSource;
import net.mt1006.mocap.api.v1.controller.config.MocapPlaybackConfig;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.api.v1.io.CommandInfo;
import net.mt1006.mocap.api.v1.modifiers.MocapModifiers;
import net.mt1006.mocap.api.v1.modifiers.MocapPlayerSkin;
import net.mt1006.mocap.events.PlayerConnectionEvent;
import net.mt1006.mocap.mocap.actions.Die;
import net.mt1006.mocap.mocap.files.RecordingData;
import net.mt1006.mocap.mocap.settings.Settings;
import net.mt1006.mocap.network.MocapPacketS2C;
import net.mt1006.mocap.utils.EntityData;
import net.mt1006.mocap.utils.FakePlayer;
import net.mt1006.mocap.utils.ProfileUtils;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

import java.util.UUID;

public class RecordingPlayback extends Playback
{
	private final RecordingData recording;
	private final ActionContext ctx;
	private int pos = 0;

	private RecordingPlayback(boolean isRoot, @Nullable class_3222 owner, MocapPlaybackConfig config,
							  MocapModifiers modifiers, RecordingData recording, ActionContext ctx)
	{
		super(isRoot, owner, config, modifiers);
		this.recording = recording;
		this.ctx = ctx;
	}

	public static @Nullable RecordingPlayback start(CommandInfo info, boolean isRoot, RecordingData recording, MocapPlaybackConfig config,
													MocapModifiers modifiers, @Nullable PositionTransformer parentTransformer)
	{
		if (recording == null) { throw new RuntimeException("Provided recording data is null!"); }

		GameProfile oldProfile = getGameProfile(info, modifiers.getPlayerName(), recording.playerName, config.getStartAsRecorded());
		if (oldProfile == null)
		{
			info.sendFailure("playback.start.error");
			info.sendFailure("playback.start.error.profile");
			return null;
		}
		GameProfile newProfile = createNewProfile(info, oldProfile, modifiers.getPlayerSkin());

		class_3218 level = getLevel(info, recording, config.getDimensionSource());
		class_3324 packetTargets = info.getServer().method_3760();
		class_1297 entity;
		FakePlayer ghost = null;

		class_243 center = modifiers.getTransformations().calculateCenter(recording.startPos);
		PositionTransformer transformer = new PositionTransformer(modifiers.getTransformations(), parentTransformer, center);
		boolean delayedStart = (modifiers.getTimeModifiers().getStartDelay().ticks != 0);

		if (!modifiers.getPlayerAsEntity().isEnabled())
		{
			FakePlayer fakePlayer = new FakePlayer(level, newProfile, config.getInvulnerablePlayback());
			entity = fakePlayer;

			fakePlayer.field_13974.method_30118(Settings.USE_CREATIVE_GAME_MODE.val ? class_1934.field_9220 : class_1934.field_9215);
			recording.initEntityPosition(fakePlayer, transformer, delayedStart);
			modifiers.getTransformations().applyScaleToPlayer(fakePlayer);

			packetTargets.method_14581(new class_2703(class_2703.class_5893.field_29136, fakePlayer));
			level.method_18213(fakePlayer);

			recording.preExecute(new PreExecuteContext(recording, entity, level, config, modifiers, transformer));
			EntityData.PLAYER_SKIN_PARTS.set(fakePlayer, (byte)0b01111111);

			if (!config.getCanPushEntities())
			{
				for (class_3222 player : PlayerConnectionEvent.players)
				{
					MocapPacketS2C.sendNocolPlayerAdd(player, fakePlayer.method_5667());
					PlayerConnectionEvent.addNocolPlayer(fakePlayer.method_5667());
				}
			}
		}
		else
		{
			entity = modifiers.getPlayerAsEntity().createEntity(level);
			if (entity == null)
			{
				info.sendFailure("playback.start.warning.unknown_entity", modifiers.getPlayerAsEntity().getRawEntityId());
				return null;
			}

			recording.initEntityPosition(entity, transformer, delayedStart);
			entity.method_18800(0.0, 0.0, 0.0);
			entity.method_5684(config.getInvulnerablePlayback());
			entity.method_5875(true);
			if (entity instanceof class_1308) { ((class_1308)entity).method_5977(true); }
			modifiers.getTransformations().applyScaleToPlayer(entity);

			level.method_8649(entity);
			recording.preExecute(new PreExecuteContext(recording, entity, level, config, modifiers, transformer));

			if (Settings.ALLOW_GHOSTS.val)
			{
				ghost = new FakePlayer(level, newProfile, config.getInvulnerablePlayback());
				ghost.field_13974.method_30118(Settings.USE_CREATIVE_GAME_MODE.val ? class_1934.field_9220 : class_1934.field_9215);
				recording.initEntityPosition(ghost, transformer, delayedStart);
				level.method_18213(ghost);
			}
		}

		ActionContext ctx = new ActionContext(recording, info.getSourcePlayer(), packetTargets, entity, config, modifiers, ghost, transformer);
		RecordingPlayback playback = new RecordingPlayback(isRoot, info.getSourcePlayer(), config, modifiers, recording, ctx);

		if (entity instanceof FakePlayer) { ((FakePlayer)entity).playback = playback; }
		else if (ghost != null) { ghost.playback = playback; }

		return playback;
	}

	private static class_3218 getLevel(CommandInfo info, RecordingData recording, MocapDimensionSource dimensionSource)
	{
		if (recording.dimensionId == null)
		{
			return switch (dimensionSource)
			{
				case ASSIGNED_OR_CURRENT, CURRENT -> info.getLevel();
				case ASSIGNED_OR_OVERWORLD, OVERWORLD -> info.getServer().method_30002();
			};
		}
		else
		{
			return switch (dimensionSource)
			{
				case ASSIGNED_OR_CURRENT, ASSIGNED_OR_OVERWORLD -> info.getServer()
						.method_3847(class_5321.method_29179(class_7924.field_41223, recording.dimensionId));
				case CURRENT -> info.getLevel();
				case OVERWORLD -> info.getServer().method_30002();
			};
		}
	}

	private static @Nullable GameProfile getGameProfile(CommandInfo info, @Nullable String profileName,
														@Nullable String recordedName, boolean startAsRecorded)
	{
		class_1297 entity = info.getSourceEntity();
		class_3324 playerList = info.getServer().method_3760();

		if (profileName == null)
		{
			if (startAsRecorded && recordedName != null) { profileName = recordedName; }
			else if (entity instanceof class_3222) { profileName = ((class_3222)entity).method_7334().name(); }
			else if (!playerList.method_14571().isEmpty()) { profileName = playerList.method_14571().get(0).method_7334().name(); }
			else { profileName = "Player"; }
		}

		return ProfileUtils.getGameProfile(info.getServer(), profileName);
	}

	private static GameProfile createNewProfile(CommandInfo info, GameProfile oldProfile, MocapPlayerSkin playerSkin)
	{
		// duplicates oldProfile but with random UUID and proper player skin
		PropertyMap newPropertyMap = playerSkin.addSkinToPropertyMap(info, oldProfile.properties());
		return new GameProfile(UUID.randomUUID(), oldProfile.name(), newPropertyMap);
	}

	@Override public void tick()
	{
		if (finished) { return; }

		if (shouldExecuteTick())
		{
			if (waitOnEnd != 0)
			{
				if (waitOnEnd == 1) { finished = true; }
				waitOnEnd--;
			}
			else
			{
				int startDelay = modifiers.getTimeModifiers().getStartDelay().ticks;
				int waitOnStart = modifiers.getTimeModifiers().getWaitOnStart().ticks;

				if (startDelay == tickCounter)
				{
					boolean delayedStart = (modifiers.getTimeModifiers().getStartDelay().ticks != 0);
					if (delayedStart) { recording.initEntityPosition(ctx.getEntity(), ctx.getTransformer(), false); }

					recording.firstExecute(ctx.getEntity());
					tickInitialActions();
				}
				if (startDelay + waitOnStart <= tickCounter) { tickActions(); }
			}
			tickCounter++;
		}

		if (finished && modifiers.getTimeModifiers().getLoop()) { loop(); }
		else if (shouldSelfStop()) { stop(); }
	}

	private void tickInitialActions()
	{
		int tempPos = 0;
		while (true)
		{
			MocapAction.Result result = recording.executeAction(ctx, config, true, tempPos++);
			switch (result)
			{
				case OK, IGNORED:
					break;

				case NEXT_TICK, REPEAT_TICK, END:
					return;

				case ERROR:
					Utils.sendMessage(owner, "error.playback_error");
					MocapMod.LOGGER.error("Something went wrong during initial tick!");
					finished = true;
					return;

				default:
					throw new IllegalStateException("Unexpected value: " + result);
			}
		}
	}

	private void tickActions()
	{
		while (true)
		{
			MocapAction.Result result = recording.executeAction(ctx, config, false, pos++);
			switch (result)
			{
				case OK, IGNORED:
					break;

				case NEXT_TICK:
					return;

				case REPEAT_TICK:
					pos--;
					return;

				case END:
					if (recording.endsWithDeath) { Die.INSTANCE.execute(ctx); }
					finishOrWaitOnEnd();
					return;

				case ERROR:
					Utils.sendMessage(owner, "error.playback_error");
					MocapMod.LOGGER.error("Something went wrong during playback!");
					finished = true;
					return;

				default:
					throw new IllegalStateException("Unexpected value: " + result);
			}
		}
	}

	@Override public void stop()
	{
		if (!stopped)
		{
			ctx.removeMainEntity();
			ctx.removeAdditionalEntities();
			finished = true;
			stopped = true;
		}
	}

	@Override protected void loop()
	{
		boolean delayedStart = (modifiers.getTimeModifiers().getStartDelay().ticks != 0);
		recording.initEntityPosition(ctx.getEntity(), ctx.getTransformer(), delayedStart);

		ctx.removeAdditionalEntities();
		pos = 0;
		tickCounter = 0;
		finished = false;
	}
}
