package net.mt1006.mocap.mocap.playing.skins;

import com.mojang.datafixers.util.Pair;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1060;
import net.minecraft.class_12079;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.mt1006.mocap.MocapMod;
import net.mt1006.mocap.mocap.files.Files;
import net.mt1006.mocap.mocap.settings.Settings;
import net.mt1006.mocap.network.MocapPacketC2S;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CustomClientSkinManager
{
	private static final int MAX_CLIENT_CACHE_SIZE = 4096;
	private static final String SKIN_RES_PREFIX = "custom_skin/";
	private static final String SLIM_SKIN_RES_PREFIX = SKIN_RES_PREFIX + Files.SLIM_SKIN_PREFIX;
	private static final ConcurrentMap<String, Boolean> skinCache = new ConcurrentHashMap<>();
	private static boolean clientWarned = false;

	public static @Nullable class_12079.class_12081 get(@Nullable String name)
	{
		if (name == null) { return null; }
		Boolean accessible = skinCache.get(name);

		if (accessible == null)
		{
			loadClientSkin(name);
			return null;
		}
		if (!accessible) { return null; }

		class_2960 id = resFromName(name);
		return new class_12079.class_10726(id, id);
	}

	public static void loadClientSkin(String name)
	{
		if (skinCache.size() > MAX_CLIENT_CACHE_SIZE)
		{
			if (clientWarned) { return; }

			class_1657 player = class_310.method_1551().field_1724;
			if (player == null) { return; }

			Utils.sendMessage(player, "warning.custom_skin_cache_limit");
			if (Settings.SHOW_TIPS.val) { Utils.sendMessage(player, "warning.custom_skin_cache_limit.tip"); }
			clientWarned = true;
			return;
		}

		skinCache.put(name, false);
		MocapPacketC2S.sendRequestCustomSkin(name);
	}

	public static void register(Pair<String, byte[]> customSkinData)
	{
		//TODO: test!!!
		//TODO: fix memory leak?
		String name = customSkinData.getFirst();
		byte[] array = customSkinData.getSecond();

		Boolean accessible = skinCache.get(name);
		if (accessible == null || accessible) { return; }

		try
		{
			class_1011 nativeImage;

			try
			{
				nativeImage = class_1011.method_49277(array);
			}
			catch (IOException e)
			{
				Utils.exception(e, "Failed to load skin texture into buffer!");
				return;
			}

			if (nativeImage.method_4307() > 4096 || nativeImage.method_4323() > 4096)
			{
				MocapMod.LOGGER.warn("Skin texture too big!");
				return;
			}

			class_2960 id = resFromName(name);
			class_310.method_1551().method_1531().method_4616(id, new class_1043(id::toString, nativeImage));
			skinCache.put(name, true);
		}
		catch (Exception e) { Utils.exception(e, "Failed to read skin texture!"); }
	}

	public static void clearCache()
	{
		class_1060 textureManager = class_310.method_1551().method_1531();
		for (Map.Entry<String, Boolean> entry : skinCache.entrySet())
		{
			Boolean val = entry.getValue();
			if (val != null && val) { textureManager.method_4615(resFromName(entry.getKey())); }
		}
		skinCache.clear();
		clientWarned = false;
	}

	public static boolean isSlimSkin(class_12079.class_12081 texture)
	{
		return texture.comp_3627().method_12832().startsWith(SLIM_SKIN_RES_PREFIX);
	}

	private static class_2960 resFromName(String name)
	{
		return class_2960.method_60655(MocapMod.MOD_ID, SKIN_RES_PREFIX + name);
	}
}
