package net.mt1006.mocap.mocap.recording;

import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.mt1006.mocap.api.v1.extension.MocapActiveRecordingActions;
import net.mt1006.mocap.mixin.fields.LevelFields;
import net.mt1006.mocap.mocap.actions.EntityUpdate;
import net.mt1006.mocap.mocap.playing.PlaybackManager;
import org.jetbrains.annotations.Nullable;

import java.util.*;

public class EntityTracker
{
	private final RecordingContext ctx;
	private final Map<class_1297, TrackedEntity> map = new HashMap<>();
	private int counter = 0;
	private class_1297 playerVehicle = null;

	public EntityTracker(RecordingContext ctx)
	{
		this.ctx = ctx;
	}
	
	public TrackedEntity get(class_1297 entity)
	{
		return map.get(entity);
	}

	public Collection<TrackedEntity> getAll()
	{
		return map.values();
	}

	public void onTick()
	{
		if (ctx.config.getEntityTrackingDistance() != 0.0)
		{
			updateTracked();
			updateVehicle();
		}
		removeOld();
	}

	private void updateTracked()
	{
		double entityTrackingDist = ctx.config.getEntityTrackingDistance();
		boolean limitDistance = entityTrackingDist >= 0.0;
		double maxDistanceSqr = entityTrackingDist * entityTrackingDist;

		for (class_1297 entity : ((LevelFields)ctx.recordedPlayer.method_51469()).callGetEntities().method_31803())
		{
			if ((limitDistance && ctx.recordedPlayer.method_5858(entity) > maxDistanceSqr) || entity instanceof class_1657
					|| (ctx.config.getPreventTrackingPlayedEntities() && entity.method_5752().contains(PlaybackManager.MOCAP_ENTITY_TAG)))
			{
				continue;
			}

			if (!ctx.entityFilter.isAllowed(entity)) { continue; }

			TrackedEntity trackedEntity = map.get(entity);
			if (trackedEntity == null)
			{
				trackedEntity = new TrackedEntity(ctx, counter++, entity);
				map.put(entity, trackedEntity);
				ctx.addAction(EntityUpdate.addEntity(trackedEntity.id, entity, ctx.config));
			}
			trackedEntity.onTick();
		}
	}

	private void updateVehicle()
	{
		class_1297 newPlayerVehicle = ctx.recordedPlayer.method_5854();
		if (newPlayerVehicle == null)
		{
			if (playerVehicle != null)
			{
				ctx.addAction(EntityUpdate.playerDismount());
				playerVehicle = null;
			}
			return;
		}

		if (newPlayerVehicle.equals(playerVehicle)) { return; }

		if (playerVehicle != null)
		{
			ctx.addAction(EntityUpdate.playerDismount());
			playerVehicle = null;
		}

		TrackedEntity trackedEntity = map.get(newPlayerVehicle);
		if (trackedEntity != null)
		{
			ctx.addAction(EntityUpdate.playerMount(trackedEntity.id));
			playerVehicle = newPlayerVehicle;
		}
	}

	private void removeOld()
	{
		int tick = ctx.getTick();
		List<class_1297> toRemove = new ArrayList<>();

		for (Map.Entry<class_1297, TrackedEntity> entry : map.entrySet())
		{
			if (entry.getValue().lastTick == tick) { continue; }

			if (!entry.getValue().dying)
			{
				int entityId = entry.getValue().id;
				EntityUpdate entityUpdate = entry.getKey().method_35049() == class_1297.class_5529.field_26998
						? EntityUpdate.kill(entityId) : EntityUpdate.removeEntity(entityId);
				ctx.addAction(entityUpdate);
			}
			toRemove.add(entry.getKey());
		}
		toRemove.forEach(map::remove);
	}

	public static class TrackedEntity implements MocapActiveRecordingActions.TrackedEntity
	{
		private final RecordingContext ctx;
		private final int id;
		private final class_1297 entity;
		private final PositionTracker positionTracker;
		private @Nullable RecordedEntityState previousState = null;
		private boolean dying;
		private int lastTick;

		public TrackedEntity(RecordingContext ctx, int id, class_1297 entity)
		{
			this.ctx = ctx;
			this.id = id;
			this.entity = entity;
			this.positionTracker = new PositionTracker(entity, true, ctx.data.startPos);
		}

		public void onTick()
		{
			RecordedEntityState state = new RecordedEntityState(entity);
			state.saveTrackedEntityDifference(ctx.data.actions, id, previousState);
			previousState = state;

			positionTracker.onTick(ctx.data.actions, id);
			lastTick = ctx.getTick();

			if (entity instanceof class_1309 && ((class_1309)entity).method_29504() && !dying)
			{
				ctx.addAction(EntityUpdate.kill(id));
				dying = true;
			}
		}

		@Override public MocapActiveRecordingActions getParent()
		{
			return ctx;
		}

		@Override public int getId()
		{
			return id;
		}

		@Override public class_1297 getEntity()
		{
			return entity;
		}
	}
}
