package net.mt1006.mocap.mocap.recording;

import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.mt1006.mocap.api.v1.extension.actions.MocapAction;
import net.mt1006.mocap.mocap.actions.EntityAction;
import net.mt1006.mocap.mocap.actions.Movement;
import net.mt1006.mocap.mocap.files.RecordingData;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public class PositionTracker
{
	public static final class_243 FAR_AWAY = new class_243(0.0, 1000000.0, 0.0);
	private class_1297 entity;
	private final class_243 startPos;
	private class_243 pos;
	private final float[] rotation = new float[2];
	private float headRot;
	private boolean onGround;
	private boolean forceNonPosDataFlag;

	public PositionTracker(class_1297 entity, boolean initRotAndGround, class_243 startPos)
	{
		this.entity = entity;
		this.startPos = startPos;

		this.pos = entity.method_73189();
		this.rotation[0] = entity.method_36455();
		this.rotation[1] = entity.method_36454();
		this.headRot = entity.method_5791();
		this.onGround = entity.method_24828();

		this.forceNonPosDataFlag = initRotAndGround;
	}

	public void setEntity(class_1297 entity)
	{
		this.entity = entity;
	}

	public void onTick(List<MocapAction> actionList, @Nullable Integer entityId)
	{
		Movement movement = getDelta(true, forceNonPosDataFlag);
		forceNonPosDataFlag = false;

		if (movement == null) { return; }
		actionList.add(entityId != null ? new EntityAction(entityId, movement) : movement);
	}

	public void teleportFarAway(List<MocapAction> actionList)
	{
		Movement movement = Movement.teleportToPos(FAR_AWAY, false);
		actionList.add(movement);

		pos = movement.getNewPosition(startPos, pos);
		rotation[0] = 0.0f;
		rotation[1] = 0.0f;
		headRot = 0.0f;
		onGround = false;
	}

	public @Nullable Movement getDelta()
	{
		return getDelta(false, false);
	}

	private @Nullable Movement getDelta(boolean applyChanges, boolean forceNonPosData)
	{
		float newXRot = entity.method_36455(), newYRot = entity.method_36454(), newHeadRot = entity.method_5791();
		boolean newOnGround = entity.method_24828();

		Movement movement = Movement.delta(startPos, pos, entity.method_73189(), rotation,
				newXRot, newYRot, headRot, newHeadRot, onGround, newOnGround, forceNonPosData);

		if (applyChanges)
		{
			rotation[0] = newXRot;
			rotation[1] = newYRot;
			headRot = newHeadRot;
			onGround = newOnGround;
			if (movement != null) { pos = movement.getNewPosition(startPos, pos); }
		}
		return movement;
	}

	public void writeStartPos(RecordingData data)
	{
		data.startPos = startPos;

		// unlike in other places, file header has first rotY, than rotX
		data.startRot[0] = rotation[1];
		data.startRot[1] = rotation[0];
	}
}
