package net.mt1006.mocap.network;

import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import net.mt1006.mocap.MocapMod;
import net.mt1006.mocap.events.PlayerConnectionEvent;
import net.mt1006.mocap.mocap.playing.skins.CustomServerSkinManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MocapPacketC2S implements class_8710
{
	private static final String TYPE_ID = MocapMod.loaderInterface.getLoaderName().toLowerCase() + "_c2s";
	public static final class_9154<MocapPacketC2S> TYPE = new class_9154<>(class_2960.method_60655(MocapMod.MOD_ID, TYPE_ID));
	public static final class_9139<class_2540, MocapPacketC2S> CODEC = class_9139.method_56437((b, p) -> p.encode(b), MocapPacketC2S::new);

	public static final int ACCEPT_SERVER = 0;
	public static final int REQUEST_CUSTOM_SKIN = 1;

	private final int version;
	private final int op;
	private final Object object;

	public MocapPacketC2S(int op, Object object)
	{
		this.version = MocapMod.NETWORK_PACKETS_VERSION;
		this.op = op;
		this.object = object;
	}

	public MocapPacketC2S(class_2540 buf)
	{
		version = buf.readInt();
		op = buf.readInt();

		switch (op)
		{
			case REQUEST_CUSTOM_SKIN:
				object = NetworkUtils.readString(buf);
				break;

			default:
				object = null;
		}
	}

	@Override public @NotNull class_9154<? extends class_8710> method_56479()
	{
		return TYPE;
	}

	public class_2540 encode(class_2540 buf)
	{
		buf.method_53002(version);
		buf.method_53002(op);

		if (op == REQUEST_CUSTOM_SKIN && object instanceof String)
		{
			NetworkUtils.writeString(buf, (String)object);
		}
		return buf;
	}

	public void handle(Client client)
	{
		if (version != MocapMod.NETWORK_PACKETS_VERSION) { return; }
		class_3222 player = client.getPlayer();

		switch (op)
		{
			case ACCEPT_SERVER:
				PlayerConnectionEvent.addPlayer(player);
				PlayerConnectionEvent.experimentalReleaseWarning(player);
				break;

			case REQUEST_CUSTOM_SKIN:
				if (object instanceof String) { CustomServerSkinManager.sendSkinToClient(player, (String)object); }
				break;
		}
	}

	public static void sendAcceptServer(MocapPacketS2C.Server server)
	{
		server.respond(new MocapPacketC2S(ACCEPT_SERVER, null));
	}

	public static void sendRequestCustomSkin(String name)
	{
		send(REQUEST_CUSTOM_SKIN, name);
	}

	private static void send(int op, Object object)
	{
		MocapMod.loaderInterface.sendPacketToServer(new MocapPacketC2S(op, object));
	}

	public interface Client
	{
		@Nullable class_3222 getPlayer();
		void respond(MocapPacketS2C packet);
	}
}
