package net.mt1006.mocap.network;

import com.mojang.datafixers.util.Pair;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import net.mt1006.mocap.MocapMod;
import net.mt1006.mocap.events.PlayerConnectionEvent;
import net.mt1006.mocap.mocap.playing.skins.CustomClientSkinManager;
import org.jetbrains.annotations.NotNull;

import java.util.UUID;

public class MocapPacketS2C implements class_8710
{
	private static final String TYPE_ID = MocapMod.loaderInterface.getLoaderName().toLowerCase() + "_s2c";
	public static final class_9154<MocapPacketS2C> TYPE = new class_9154<>(class_2960.method_60655(MocapMod.MOD_ID, TYPE_ID));
	public static final class_9139<class_2540, MocapPacketS2C> CODEC = class_9139.method_56437((b, p) -> p.encode(b), MocapPacketS2C::new);

	public static final int ON_LOGIN = 0;
	public static final int NOCOL_PLAYER_ADD = 1;
	public static final int NOCOL_PLAYER_REMOVE = 2;
	public static final int CUSTOM_SKIN_DATA = 5;
	public static final int CLEAR_CACHE = 6;

	private final int version;
	private final int op;
	private final Object object;

	public MocapPacketS2C(int op, Object object)
	{
		this.version = MocapMod.NETWORK_PACKETS_VERSION;
		this.op = op;
		this.object = object;
	}

	public MocapPacketS2C(class_2540 buf)
	{
		version = buf.readInt();
		op = buf.readInt();

		switch (op)
		{
			case NOCOL_PLAYER_ADD:
			case NOCOL_PLAYER_REMOVE:
				object = buf.method_10790();
				break;

			case CUSTOM_SKIN_DATA:
				String customSkinName = NetworkUtils.readString(buf);
				byte[] customSkinArray = NetworkUtils.readByteArray(buf);
				object = Pair.of(customSkinName, customSkinArray);
				break;

			default:
				object = null;
		}
	}

	@Override public @NotNull class_9154<? extends class_8710> method_56479()
	{
		return TYPE;
	}

	public void encode(class_2540 buf)
	{
		buf.method_53002(version);
		buf.method_53002(op);

		switch (op)
		{
			case NOCOL_PLAYER_ADD:
			case NOCOL_PLAYER_REMOVE:
				if (object instanceof UUID) { buf.method_10797((UUID)object); }
				break;

			case CUSTOM_SKIN_DATA:
				if (!(object instanceof Pair<?,?>)) { break; }
				Pair<String, byte[]> customSkinData = (Pair<String, byte[]>)object;
				NetworkUtils.writeString(buf, customSkinData.getFirst());
				NetworkUtils.writeByteArray(buf, customSkinData.getSecond());
				break;
		}
	}

	public void handle(Server server)
	{
		if (version != MocapMod.NETWORK_PACKETS_VERSION) { return; }

 		switch (op)
		{
			case ON_LOGIN: MocapPacketC2S.sendAcceptServer(server); break;
			case NOCOL_PLAYER_ADD: PlayerConnectionEvent.addNocolPlayer((UUID)object); break;
			case NOCOL_PLAYER_REMOVE: PlayerConnectionEvent.removeNocolPlayer((UUID)object); break;
			case CUSTOM_SKIN_DATA: CustomClientSkinManager.register((Pair<String, byte[]>)object); break;
			case CLEAR_CACHE: CustomClientSkinManager.clearCache();
		}
	}

	public static void sendOnLogin(MocapPacketC2S.Client client)
	{
		client.respond(new MocapPacketS2C(ON_LOGIN, null));
	}

	public static void sendNocolPlayerAdd(class_3222 serverPlayer, UUID playerToAdd)
	{
		send(serverPlayer, NOCOL_PLAYER_ADD, playerToAdd);
	}

	public static void sendNocolPlayerRemove(class_3222 serverPlayer, UUID playerToAdd)
	{
		send(serverPlayer, NOCOL_PLAYER_REMOVE, playerToAdd);
	}

	public static void sendCustomSkinData(class_3222 player, String name, byte[] byteArray)
	{
		send(player, CUSTOM_SKIN_DATA, Pair.of(name, byteArray));
	}

	public static void sendClearCache(class_3222 player)
	{
		send(player, CLEAR_CACHE, null);
	}

	private static void send(class_3222 player, int op, Object object)
	{
		MocapMod.loaderInterface.sendPacketToClient(player, new MocapPacketS2C(op, object));
	}

	public interface Server
	{
		void respond(MocapPacketC2S packet);
	}
}
