package net.mt1006.mocap.utils;

import net.minecraft.class_1297;
import net.minecraft.class_2394;
import net.minecraft.class_2940;
import net.mt1006.mocap.MocapMod;
import net.mt1006.mocap.mixin.fields.*;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public class EntityData
{
	public static final DataIndex<Byte> ENTITY_FLAGS =                                    new DataIndex<>(EntityFields.getDATA_SHARED_FLAGS_ID());
	public static final DataIndex<Byte> LIVING_ENTITY_FLAGS =                             new DataIndex<>(LivingEntityFields.getDATA_LIVING_ENTITY_FLAGS());
	public static final DataIndex<List<class_2394>> LIVING_ENTITY_EFFECT_PARTICLES = new DataIndex<>(LivingEntityFields.getDATA_EFFECT_PARTICLES());
	public static final DataIndex<Boolean> LIVING_ENTITY_EFFECT_AMBIENCE =                new DataIndex<>(LivingEntityFields.getDATA_EFFECT_AMBIENCE_ID());
	public static final DataIndex<Byte> PLAYER_SKIN_PARTS =                               new DataIndex<>(AvatarMixin.getDATA_PLAYER_MODE_CUSTOMISATION());
	public static final DataIndex<Byte> ABSTRACT_HORSE_FLAGS =                            new DataIndex<>(AbstractHorseFields.getDATA_ID_FLAGS());
	public static final DataIndex<Boolean> AGEABLE_MOB_IS_BABY =                          new DataIndex<>(AgeableModFields.getDATA_BABY_ID());

	public static class DataIndex<T>
	{
		private final @Nullable class_2940<T> accessor;

		public DataIndex(@Nullable class_2940<T> accessor)
		{
			this.accessor = accessor;
			if (accessor == null) { MocapMod.LOGGER.error("Failed to initialize one of the data indexes!"); }
		}

		public void set(class_1297 entity, T val)
		{
			if (accessor != null) { entity.method_5841().method_12778(accessor, val); }
		}

		public T valOrDef(class_1297 entity, T defVal)
		{
			return accessor != null ? entity.method_5841().method_12789(accessor) : defVal;
		}
	}
}
