package net.mt1006.mocap.utils;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import net.minecraft.class_11560;
import net.minecraft.class_11561;
import net.minecraft.class_310;
import net.minecraft.class_3312;
import net.minecraft.class_4844;
import net.minecraft.server.MinecraftServer;
import net.mt1006.mocap.MocapMod;

import java.io.File;
import java.util.*;

public class ProfileUtils
{
	// Original source code: https://github.com/iChun/iChunUtil/blob/1.16/src/main/java/me/ichun/mods/ichunutil/common/entity/util/EntityHelper.java

	public static final String USERID_CACHE_FILE = "usercache.json";
	public static final Map<String, GameProfile> gameProfileCache = Collections.synchronizedMap(new HashMap<>());
	public static class_11561 profileCache = null;
	public static MinecraftSessionService sessionService = null;

	public static GameProfile getGameProfile(MinecraftServer server, String playerName)
	{
		if (gameProfileCache.containsKey(playerName)) { return gameProfileCache.get(playerName); }

		if (profileCache == null || sessionService == null)
		{
			if (MocapMod.isDedicatedServer)
			{
				sessionService = server.method_73550().comp_837();
				profileCache = server.method_73550().comp_4407();
			}
			else
			{
				setClientProfileLookupObjects();
			}
		}

		UUID offlineUUID = class_4844.method_43344(playerName);

		Optional<class_11560> playerInfoOpt = profileCache != null ? profileCache.method_14515(playerName) : Optional.empty();
		class_11560 playerInfo = playerInfoOpt.orElse(new class_11560(offlineUUID, playerName));
		GameProfile gameProfile = new GameProfile(playerInfo.comp_4422(), playerInfo.comp_4423());

		Property property = Iterables.getFirst(gameProfile.properties().get("textures"), null);
		if (property == null && !playerInfo.comp_4422().equals(offlineUUID))
		{
			ProfileResult profileResult = sessionService.fetchProfile(gameProfile.id(), true);
			if (profileResult != null) { gameProfile = profileResult.profile(); }
		}

		gameProfileCache.put(gameProfile.name(), gameProfile);
		return gameProfile;
	}

	private static void setClientProfileLookupObjects()
	{
		YggdrasilAuthenticationService yggdrasilauthenticationservice = new YggdrasilAuthenticationService(class_310.method_1551().method_1487());
		sessionService = yggdrasilauthenticationservice.createMinecraftSessionService();
		GameProfileRepository gameprofilerepository = yggdrasilauthenticationservice.createProfileRepository();
		profileCache = new class_3312(gameprofilerepository, new File(class_310.method_1551().field_1697, USERID_CACHE_FILE));
	}
}
